/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.substitutions;

import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Type;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.replacements.nodes.ArrayCopyWithConversionsNode;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfMacroNode;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesMacroNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.word.LocationIdentity;

public class TruffleInvocationPlugins {
    public static void register(Architecture architecture, InvocationPlugins plugins, Replacements replacements) {
        if (architecture instanceof AMD64 || architecture instanceof AArch64) {
            TruffleInvocationPlugins.registerTStringPlugins(plugins, replacements);
            TruffleInvocationPlugins.registerArrayUtilsPlugins(plugins, replacements);
        }
    }

    private static void registerArrayUtilsPlugins(InvocationPlugins plugins, Replacements replacements) {
        plugins.registerIntrinsificationPredicate(t -> t.getName().equals("Lcom/oracle/truffle/api/ArrayUtils;"));
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.api.ArrayUtils", replacements);
        for (final Stride stride : new Stride[]{Stride.S1, Stride.S2}) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB1" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0) {
                    return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Byte, stride, array, fromIndex, maxIndex, v0);
                }
            });
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB2" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                    return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Byte, stride, array, fromIndex, maxIndex, v0, v1);
                }
            });
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB3" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2) {
                    return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Byte, stride, array, fromIndex, maxIndex, v0, v1, v2);
                }
            });
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB4" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                    return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Byte, stride, array, fromIndex, maxIndex, v0, v1, v2, v3);
                }
            });
        }
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC1S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0) {
                return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Char, Stride.S2, array, fromIndex, maxIndex, v0);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC2S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Char, Stride.S2, array, fromIndex, maxIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC3S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2) {
                return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Char, Stride.S2, array, fromIndex, maxIndex, v0, v1, v2);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC4S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                return TruffleInvocationPlugins.arrayUtilsIndexOfAny(b, JavaKind.Char, Stride.S2, array, fromIndex, maxIndex, v0, v1, v2, v3);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOf2ConsecutiveS1", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.arrayUtilsIndexOf(b, JavaKind.Byte, Stride.S1, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, array, fromIndex, maxIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOf2ConsecutiveS2", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.arrayUtilsIndexOf(b, JavaKind.Byte, Stride.S2, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, array, fromIndex, maxIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOf2ConsecutiveS2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.arrayUtilsIndexOf(b, JavaKind.Char, Stride.S2, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, array, fromIndex, maxIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubRegionEqualsS1", new Type[]{byte[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext graph, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length) {
                return TruffleInvocationPlugins.arrayUtilsRegionEquals(graph, arrayA, offsetA, arrayB, offsetB, length, JavaKind.Byte, Stride.S1, Stride.S1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubRegionEqualsS2S1", new Type[]{byte[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext graph, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length) {
                return TruffleInvocationPlugins.arrayUtilsRegionEquals(graph, arrayA, offsetA, arrayB, offsetB, length, JavaKind.Byte, Stride.S2, Stride.S1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("stubRegionEqualsS2", new Type[]{char[].class, Long.TYPE, char[].class, Long.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext graph, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length) {
                return TruffleInvocationPlugins.arrayUtilsRegionEquals(graph, arrayA, offsetA, arrayB, offsetB, length, JavaKind.Char, Stride.S2, Stride.S2);
            }
        });
    }

    private static boolean arrayUtilsIndexOfAny(GraphBuilderContext b, JavaKind arrayKind, Stride stride, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode ... values) {
        return TruffleInvocationPlugins.arrayUtilsIndexOf(b, arrayKind, stride, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, array, fromIndex, maxIndex, values);
    }

    public static boolean arrayUtilsIndexOf(GraphBuilderContext b, JavaKind arrayKind, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode ... values) {
        ConstantNode baseOffset = ConstantNode.forLong(b.getMetaAccess().getArrayBaseOffset(arrayKind), b.getGraph());
        GraalError.guarantee(variant != LIRGeneratorTool.ArrayIndexOfVariant.MatchRange && variant != LIRGeneratorTool.ArrayIndexOfVariant.Table, "ArrayIndexOf variants \"matchRange\" and \"table\" require more CPU features than just SSE2 and must be inserted via ArrayIndexOfMacroNode");
        b.addPush(JavaKind.Int, new ArrayIndexOfNode(stride, variant, null, NamedLocationIdentity.getArrayLocation(arrayKind), array, (ValueNode)baseOffset, maxIndex, fromIndex, values));
        return true;
    }

    private static boolean arrayUtilsRegionEquals(GraphBuilderContext graph, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, JavaKind arrayKind, Stride strideA, Stride strideB) {
        ValueNode byteOffsetA = TruffleInvocationPlugins.toByteOffset(graph, arrayKind, strideA, offsetA);
        ValueNode byteOffsetB = TruffleInvocationPlugins.toByteOffset(graph, arrayKind, strideB, offsetB);
        graph.addPush(JavaKind.Boolean, new ArrayRegionEqualsNode(arrayA, byteOffsetA, arrayB, byteOffsetB, length, strideA, strideB, NamedLocationIdentity.getArrayLocation(arrayKind)));
        return true;
    }

    public static ValueNode toByteOffset(GraphBuilderContext graph, JavaKind arrayKind, Stride stride, ValueNode offset) {
        ValueNode shifted = stride == Stride.S1 ? offset : graph.add(LeftShiftNode.create(offset, ConstantNode.forInt(stride.log2, graph.getGraph()), NodeView.DEFAULT));
        return graph.add(AddNode.create(shifted, ConstantNode.forLong(graph.getMetaAccess().getArrayBaseOffset(arrayKind), graph.getGraph()), NodeView.DEFAULT));
    }

    public static Stride constantStrideParam(ValueNode param) {
        if (!param.isJavaConstant()) {
            throw GraalError.shouldNotReachHere();
        }
        return Stride.fromLog2(param.asJavaConstant().asInt());
    }

    private static boolean asBoolean(ValueNode param) {
        return param.asJavaConstant().asInt() != 0;
    }

    public static boolean constantBooleanParam(ValueNode param) {
        if (!param.isJavaConstant()) {
            throw GraalError.shouldNotReachHere();
        }
        return TruffleInvocationPlugins.asBoolean(param);
    }

    public static LocationIdentity inferLocationIdentity(ValueNode isNative) {
        if (isNative.isJavaConstant()) {
            return TruffleInvocationPlugins.asBoolean(isNative) ? NamedLocationIdentity.OFF_HEAP_LOCATION : NamedLocationIdentity.getArrayLocation(JavaKind.Byte);
        }
        return LocationIdentity.any();
    }

    public static LocationIdentity inferLocationIdentity(ValueNode isNativeA, ValueNode isNativeB, boolean nativeToAny) {
        boolean isNativeBConst;
        boolean isNativeAConst;
        if (isNativeA.isJavaConstant() && isNativeB.isJavaConstant() && (isNativeAConst = TruffleInvocationPlugins.asBoolean(isNativeA)) == (isNativeBConst = TruffleInvocationPlugins.asBoolean(isNativeB))) {
            if (isNativeAConst) {
                return nativeToAny ? LocationIdentity.any() : NamedLocationIdentity.OFF_HEAP_LOCATION;
            }
            return NamedLocationIdentity.getArrayLocation(JavaKind.Byte);
        }
        return LocationIdentity.any();
    }

    private static void registerTStringPlugins(InvocationPlugins plugins, Replacements replacements) {
        plugins.registerIntrinsificationPredicate(t -> t.getName().equals("Lcom/oracle/truffle/api/strings/TStringOps;"));
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.api.strings.TStringOps", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny1", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, location, array, offset, length, stride, isNative, fromIndex, v0);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny2", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, location, array, offset, length, stride, isNative, fromIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny3", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1, ValueNode v2) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, location, array, offset, length, stride, isNative, fromIndex, v0, v1, v2);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny4", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, location, array, offset, length, stride, isNative, fromIndex, v0, v1, v2, v3);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfRange1", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, location, array, offset, length, stride, isNative, fromIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfRange2", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, location, array, offset, length, stride, isNative, fromIndex, v0, v1, v2, v3);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfTable", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, byte[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode tables) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.Table, location, array, offset, length, stride, isNative, fromIndex, tables);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOf2ConsecutiveWithStride", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1) {
                return TruffleInvocationPlugins.applyIndexOf(b, targetMethod, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, location, array, offset, length, stride, isNative, fromIndex, v0, v1);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runRegionEqualsWithStride", new Type[]{Node.class, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length, ValueNode dynamicStrides) {
                LocationIdentity locationIdentity = TruffleInvocationPlugins.inferLocationIdentity(isNativeA, isNativeB, false);
                if (dynamicStrides.isJavaConstant()) {
                    int directStubCallIndex = dynamicStrides.asJavaConstant().asInt();
                    b.addPush(JavaKind.Boolean, new ArrayRegionEqualsNode(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.getConstantStrideA(directStubCallIndex), StrideUtil.getConstantStrideB(directStubCallIndex), locationIdentity));
                } else {
                    b.addPush(JavaKind.Boolean, new ArrayRegionEqualsNode(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, locationIdentity));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runMemCmp", new Type[]{Node.class, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length, ValueNode dynamicStrides) {
                LocationIdentity locationIdentity = TruffleInvocationPlugins.inferLocationIdentity(isNativeA, isNativeB, false);
                if (dynamicStrides.isJavaConstant()) {
                    int directStubCallIndex = dynamicStrides.asJavaConstant().asInt();
                    b.addPush(JavaKind.Int, new ArrayRegionCompareToNode(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.getConstantStrideA(directStubCallIndex), StrideUtil.getConstantStrideB(directStubCallIndex), locationIdentity));
                } else {
                    b.addPush(JavaKind.Int, new ArrayRegionCompareToNode(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, locationIdentity));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runArrayCopy", new Type[]{Node.class, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length, ValueNode dynamicStrides) {
                return TruffleInvocationPlugins.applyArrayCopy(b, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runArrayCopy", new Type[]{Node.class, char[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
                return TruffleInvocationPlugins.applyArrayCopy(b, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runArrayCopy", new Type[]{Node.class, int[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
                return TruffleInvocationPlugins.applyArrayCopy(b, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesLatin1", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length, isNative);
                b.addPush(JavaKind.Int, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.LATIN1, false, TruffleInvocationPlugins.inferLocationIdentity(isNative)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesBMP", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length, isNative);
                b.addPush(JavaKind.Int, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.BMP, false, TruffleInvocationPlugins.inferLocationIdentity(isNative)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF8", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative, ValueNode assumeValid) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length, isNative, assumeValid);
                b.addPush(JavaKind.Long, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8, TruffleInvocationPlugins.constantBooleanParam(assumeValid), TruffleInvocationPlugins.inferLocationIdentity(isNative)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF16", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative, ValueNode assumeValid) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length, isNative, assumeValid);
                b.addPush(JavaKind.Long, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16, TruffleInvocationPlugins.constantBooleanParam(assumeValid), TruffleInvocationPlugins.inferLocationIdentity(isNative)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF16C", new Type[]{Node.class, char[].class, Long.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length);
                b.addPush(JavaKind.Long, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16, false, NamedLocationIdentity.getArrayLocation(JavaKind.Char)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF32", new Type[]{Node.class, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length, isNative);
                b.addPush(JavaKind.Int, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.UTF_32, false, TruffleInvocationPlugins.inferLocationIdentity(isNative)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF32I", new Type[]{Node.class, int[].class, Long.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length) {
                MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, location, array, offset, length);
                b.addPush(JavaKind.Int, new CalcStringAttributesMacroNode(params, LIRGeneratorTool.CalcStringAttributesEncoding.UTF_32, false, NamedLocationIdentity.getArrayLocation(JavaKind.Int)));
                return true;
            }
        });
    }

    private static boolean applyArrayCopy(GraphBuilderContext b, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
        if (dynamicStrides.isJavaConstant()) {
            int directStubCallIndex = dynamicStrides.asJavaConstant().asInt();
            b.add(new ArrayCopyWithConversionsNode(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.getConstantStrideA(directStubCallIndex), StrideUtil.getConstantStrideB(directStubCallIndex)));
        } else {
            b.add(new ArrayCopyWithConversionsNode(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides));
        }
        return true;
    }

    public static boolean applyIndexOf(GraphBuilderContext b, ResolvedJavaMethod targetMethod, LIRGeneratorTool.ArrayIndexOfVariant variant, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode ... values) {
        Stride constStride = TruffleInvocationPlugins.constantStrideParam(stride);
        LocationIdentity locationIdentity = TruffleInvocationPlugins.inferLocationIdentity(isNative);
        if (variant == LIRGeneratorTool.ArrayIndexOfVariant.MatchRange || variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
            ValueNode[] args = new ValueNode[7 + values.length];
            args[0] = location;
            args[1] = array;
            args[2] = offset;
            args[3] = length;
            args[4] = stride;
            args[5] = isNative;
            args[6] = fromIndex;
            System.arraycopy(values, 0, args, 7, values.length);
            MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, args);
            b.addPush(JavaKind.Int, new ArrayIndexOfMacroNode(params, constStride, variant, locationIdentity));
        } else {
            b.addPush(JavaKind.Int, new ArrayIndexOfNode(constStride, variant, null, locationIdentity, array, offset, length, fromIndex, values));
        }
        return true;
    }
}

