/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.contract.NodeCostUtil;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.compiler.PEAgnosticInlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PostPartialEvaluationSuite;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.phases.inlining.AgnosticInliningPhase;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;

final class GraphManager {
    public static final int TRIVIAL_NODE_COUNT_LIMIT = 500;
    private final PartialEvaluator partialEvaluator;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCacheForInlining;
    private final EconomicMap<CompilableTruffleAST, Entry> irCache = EconomicMap.create();
    private final TruffleTierContext rootContext;
    private final PostPartialEvaluationSuite postPartialEvaluationSuite;
    private final boolean useSize;

    GraphManager(PartialEvaluator partialEvaluator, PostPartialEvaluationSuite postPartialEvaluationSuite, TruffleTierContext rootContext) {
        this.partialEvaluator = partialEvaluator;
        this.postPartialEvaluationSuite = postPartialEvaluationSuite;
        this.rootContext = rootContext;
        this.graphCacheForInlining = partialEvaluator.getOrCreateEncodedGraphCache();
        this.useSize = (Boolean)rootContext.options.get(PolyglotCompilerOptions.InliningUseSize);
    }

    Entry pe(CompilableTruffleAST truffleAST) {
        Entry entry = (Entry)this.irCache.get((Object)truffleAST);
        if (entry == null) {
            PEAgnosticInlineInvokePlugin plugin = this.newPlugin();
            TruffleTierContext context = this.newContext(truffleAST, false);
            this.partialEvaluator.doGraphPE(context, plugin, this.graphCacheForInlining);
            context.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(truffleAST.getNodeRewritingAssumptionConstant()));
            StructuredGraph graphAfterPE = GraphManager.copyGraphForDebugDump(context);
            this.postPartialEvaluationSuite.apply(context.graph, context);
            entry = new Entry(context.graph, plugin, graphAfterPE, this.useSize ? NodeCostUtil.computeGraphSize(context.graph) : -1);
            this.irCache.put((Object)truffleAST, (Object)entry);
        }
        return entry;
    }

    private TruffleTierContext newContext(CompilableTruffleAST truffleAST, boolean finalize) {
        return new TruffleTierContext(this.partialEvaluator, this.rootContext.options, this.rootContext.debug, truffleAST, finalize ? this.partialEvaluator.getCallDirect() : this.partialEvaluator.inlineRootForCallTarget(truffleAST), this.rootContext.compilationId, this.rootContext.log, this.rootContext.task, this.rootContext.handler);
    }

    private PEAgnosticInlineInvokePlugin newPlugin() {
        return new PEAgnosticInlineInvokePlugin(this.rootContext.task.inliningData(), this.partialEvaluator);
    }

    Entry peRoot() {
        PEAgnosticInlineInvokePlugin plugin = this.newPlugin();
        this.partialEvaluator.doGraphPE(this.rootContext, plugin, this.graphCacheForInlining);
        StructuredGraph graphAfterPE = GraphManager.copyGraphForDebugDump(this.rootContext);
        this.postPartialEvaluationSuite.apply(this.rootContext.graph, this.rootContext);
        return new Entry(this.rootContext.graph, plugin, graphAfterPE, this.useSize ? NodeCostUtil.computeGraphSize(this.rootContext.graph) : -1);
    }

    UnmodifiableEconomicMap<Node, Node> doInline(Invoke invoke, StructuredGraph ir, CompilableTruffleAST truffleAST, InliningUtil.InlineeReturnAction returnAction) {
        return InliningUtil.inline(invoke, ir, true, this.partialEvaluator.inlineRootForCallTarget(truffleAST), "cost-benefit analysis", AgnosticInliningPhase.class.getName(), returnAction);
    }

    void finalizeGraph(Invoke invoke, CompilableTruffleAST truffleAST) {
        TruffleTierContext context = this.newContext(truffleAST, true);
        this.partialEvaluator.doGraphPE(context, new InlineInvokePlugin(){

            @Override
            public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                return PartialEvaluator.asInlineInfo(method);
            }
        }, this.graphCacheForInlining);
        InliningUtil.inline(invoke, context.graph, true, this.partialEvaluator.getCallInlined(), "finalization", AgnosticInliningPhase.class.getName());
    }

    private static StructuredGraph copyGraphForDebugDump(TruffleTierContext context) {
        if (context.debug.isDumpEnabled(2)) {
            return (StructuredGraph)context.graph.copy(context.debug);
        }
        return null;
    }

    static final class Entry {
        final StructuredGraph graph;
        final EconomicMap<Invoke, TruffleCallNode> invokeToTruffleCallNode;
        final List<Invoke> indirectInvokes;
        final boolean trivial;
        final StructuredGraph graphAfterPEForDebugDump;
        final int graphSize;

        Entry(StructuredGraph graph, PEAgnosticInlineInvokePlugin plugin, StructuredGraph graphAfterPEForDebugDump, int graphSize) {
            this.graph = graph;
            this.invokeToTruffleCallNode = plugin.getInvokeToTruffleCallNode();
            this.indirectInvokes = plugin.getIndirectInvokes();
            this.trivial = this.invokeToTruffleCallNode.isEmpty() && this.indirectInvokes.isEmpty() && graph.getNodes(LoopBeginNode.TYPE).count() == 0 && graph.getNodeCount() < 500;
            this.graphAfterPEForDebugDump = graphAfterPEForDebugDump;
            this.graphSize = graphSize;
        }
    }
}

