/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.loop.phases.LoopSafepointEliminationPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.phases.TruffleSafepointInsertionPhase;

public final class TruffleLoopSafepointEliminationPhase
extends LoopSafepointEliminationPhase {
    private final ResolvedJavaMethod callBoundary;

    public TruffleLoopSafepointEliminationPhase(Providers providers) {
        TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
        ResolvedJavaType callTarget = rt.resolveType(providers.getMetaAccess(), "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget");
        this.callBoundary = TruffleSafepointInsertionPhase.findMethod(callTarget, "callBoundary");
    }

    @Override
    protected void onSafepointDisabledLoopBegin(LoopEx loop) {
        for (Node node : loop.whole().nodes()) {
            if (!(node instanceof CommitAllocationNode) && !(node instanceof AbstractNewObjectNode)) continue;
            return;
        }
        loop.loopBegin().disableGuestSafepoint();
    }

    @Override
    protected boolean onCallInLoop(LoopEndNode loopEnd, FixedNode currentCallNode) {
        if (currentCallNode instanceof Invoke && this.isTruffleCall((Invoke)((Object)currentCallNode))) {
            loopEnd.disableGuestSafepoint();
            return true;
        }
        return false;
    }

    @Override
    protected boolean allowGuestSafepoints() {
        return true;
    }

    private boolean isTruffleCall(Invoke call) {
        CallTargetNode target = call.callTarget();
        if (target == null) {
            return false;
        }
        ResolvedJavaMethod method = target.targetMethod();
        if (method == null) {
            return false;
        }
        return method.equals(this.callBoundary);
    }
}

