/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.util.ListIterator;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.HighTierLoweringPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public class TruffleInjectImmutableFrameFieldsPhase
extends BasePhase<HighTierContext> {
    TruffleInjectImmutableFrameFieldsPhase() {
    }

    @Override
    protected void run(StructuredGraph graph, HighTierContext context) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntimeIfAvailable();
        if (runtime == null) {
            return;
        }
        ResolvedJavaType frameType = runtime.resolveType(context.getMetaAccess(), "com.oracle.truffle.api.impl.FrameWithoutBoxing");
        for (Node node : graph.getNodes()) {
            LoadFieldNode fieldNode;
            if (!(node instanceof LoadFieldNode) || !TruffleInjectImmutableFrameFieldsPhase.isForcedImmutable((fieldNode = (LoadFieldNode)node).field(), frameType) || fieldNode.getLocationIdentity().isImmutable()) continue;
            graph.replaceFixedWithFixed(fieldNode, graph.add(LoadFieldNode.createOverrideImmutable(fieldNode)));
        }
    }

    private static boolean isForcedImmutable(ResolvedJavaField field, ResolvedJavaType frameType) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntimeIfAvailable();
        if (runtime == null) {
            return false;
        }
        if (field.isStatic()) {
            return false;
        }
        if (!field.isFinal()) {
            return false;
        }
        if (field.isVolatile()) {
            return false;
        }
        return field.getDeclaringClass().equals(frameType);
    }

    public static void install(PhaseSuite<HighTierContext> highTier, OptionValues options) {
        if (Options.TruffleImmutableFrameFields.getValue(options).booleanValue() && TruffleCompilerRuntime.getRuntimeIfAvailable() != null) {
            ListIterator<BasePhase<HighTierContext>> phase = highTier.findPhase(HighTierLoweringPhase.class);
            phase.previous();
            phase.add(new TruffleInjectImmutableFrameFieldsPhase());
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> TruffleImmutableFrameFields = new OptionKey<Boolean>(true);
    }
}

