/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessVerificationNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameSwapNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameSwapNode> TYPE = NodeClass.create(VirtualFrameSwapNode.class);
    private final int targetSlotIndex;

    public VirtualFrameSwapNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int targetSlotIndex, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, -1, type, accessFlags);
        this.targetSlotIndex = targetSlotIndex;
        assert (accessFlags.updatesFrame());
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        ValueNode objectAlias = tool.getAlias(this.frame.getObjectArray(this.type));
        ValueNode primitiveAlias = tool.getAlias(this.frame.getPrimitiveArray(this.type));
        if (tagAlias instanceof VirtualObjectNode && objectAlias instanceof VirtualObjectNode && primitiveAlias instanceof VirtualObjectNode) {
            VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
            VirtualObjectNode objectVirtual = (VirtualObjectNode)objectAlias;
            VirtualObjectNode primitiveVirtual = (VirtualObjectNode)primitiveAlias;
            if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < objectVirtual.entryCount() && this.frameSlotIndex < primitiveVirtual.entryCount() && this.targetSlotIndex < tagVirtual.entryCount() && this.targetSlotIndex < objectVirtual.entryCount() && this.targetSlotIndex < primitiveVirtual.entryCount()) {
                ValueNode tempTag = tool.getEntry(tagVirtual, this.targetSlotIndex);
                tool.setVirtualEntry(tagVirtual, this.targetSlotIndex, tool.getEntry(tagVirtual, this.frameSlotIndex));
                tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, tempTag);
                if (this.accessFlags.isObject()) {
                    ValueNode tempValue = tool.getEntry(objectVirtual, this.targetSlotIndex);
                    tool.setVirtualEntry(objectVirtual, this.targetSlotIndex, tool.getEntry(objectVirtual, this.frameSlotIndex));
                    tool.setVirtualEntry(objectVirtual, this.frameSlotIndex, tempValue);
                }
                if (this.accessFlags.isPrimitive()) {
                    ValueNode tempPrimitive = tool.getEntry(primitiveVirtual, this.targetSlotIndex);
                    tool.setVirtualEntry(primitiveVirtual, this.targetSlotIndex, tool.getEntry(primitiveVirtual, this.frameSlotIndex));
                    tool.setVirtualEntry(primitiveVirtual, this.frameSlotIndex, tempPrimitive);
                }
                tool.delete();
                return;
            }
        }
        this.insertDeoptimization(tool);
    }

    public int getTargetSlotIndex() {
        return this.targetSlotIndex;
    }

    @Override
    public <State> void updateVerificationState(VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<State> updater, State state) {
        updater.swap(state, this.getFrameSlotIndex(), this.getTargetSlotIndex());
    }
}

