/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessVerificationNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameSetNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameSetNode> TYPE = NodeClass.create(VirtualFrameSetNode.class);
    @Node.Input
    private ValueNode value;

    public VirtualFrameSetNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, ValueNode value, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag, type, accessFlags);
        this.value = value;
        assert (accessFlags.updatesFrame());
    }

    public VirtualFrameSetNode(NewFrameNode frame, int frameSlotIndex, int accessTag, ValueNode value, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag, type, accessFlags);
        this.value = value;
        assert (accessFlags.updatesFrame());
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        JavaKind valueKind = this.value.getStackKind();
        if (this.type == VirtualFrameAccessType.Auxiliary) {
            VirtualObjectNode dataVirtual;
            ValueNode dataAlias = tool.getAlias(this.frame.getObjectArray(this.type));
            assert (valueKind == JavaKind.Object);
            if (dataAlias instanceof VirtualObjectNode && this.frameSlotIndex < (dataVirtual = (VirtualObjectNode)dataAlias).entryCount() && tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, this.value, valueKind, -1L)) {
                tool.delete();
                return;
            }
        } else {
            ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
            ValueNode dataAlias = tool.getAlias(valueKind == JavaKind.Object ? this.frame.getObjectArray(this.type) : this.frame.getPrimitiveArray(this.type));
            if (tagAlias instanceof VirtualObjectNode && dataAlias instanceof VirtualObjectNode) {
                VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
                VirtualObjectNode dataVirtual = (VirtualObjectNode)dataAlias;
                if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < dataVirtual.entryCount()) {
                    ValueNode actualValue;
                    if (this.accessFlags.setsTag()) {
                        if (this.accessFlags.isStatic()) {
                            tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstantWithStaticModifier(this.accessTag));
                        } else {
                            tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstant(this.accessTag));
                        }
                    }
                    if (tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, actualValue = this.maybeExtendForOSRStaticAccess(tool), valueKind == JavaKind.Object ? JavaKind.Object : JavaKind.Long, -1L)) {
                        ValueNode primitiveAlias;
                        if (valueKind == JavaKind.Object && (primitiveAlias = tool.getAlias(this.frame.getPrimitiveArray(this.type))) instanceof VirtualObjectNode) {
                            tool.setVirtualEntry((VirtualObjectNode)primitiveAlias, this.frameSlotIndex, ConstantNode.defaultForKind(JavaKind.Long, this.graph()), JavaKind.Long, -1L);
                        }
                        tool.delete();
                        return;
                    }
                }
            }
        }
        this.insertDeoptimization(tool);
    }

    private ValueNode maybeExtendForOSRStaticAccess(VirtualizerTool tool) {
        if (!this.isOSRRawStaticAccess()) {
            return this.value;
        }
        Stamp valueStamp = this.value.stamp(NodeView.DEFAULT);
        if (!(valueStamp instanceof PrimitiveStamp)) {
            return this.value;
        }
        return VirtualFrameSetNode.extendForOSRStaticAccess(tool, tool.getAlias(this.value));
    }

    private static ValueNode extendForOSRStaticAccess(VirtualizerTool tool, ValueNode entry) {
        JavaKind entryKind = entry.stamp(NodeView.DEFAULT).getStackKind();
        if (entryKind == JavaKind.Long) {
            return entry;
        }
        assert (entryKind.isPrimitive());
        ValueNode tmpValue = entry;
        if (entryKind.isNumericFloat()) {
            entryKind = entryKind == JavaKind.Float ? JavaKind.Int : JavaKind.Long;
            tmpValue = new ReinterpretNode(entryKind, tmpValue);
            tool.addNode(tmpValue);
        }
        if (entryKind != JavaKind.Long) {
            tmpValue = new ZeroExtendNode(tmpValue, JavaKind.Long.getBitCount());
            tool.addNode(tmpValue);
        }
        assert (tmpValue.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Long);
        return tmpValue;
    }

    private boolean isOSRRawStaticAccess() {
        return this.accessFlags.isStatic() && this.frame.isBytecodeOSRTransferTarget();
    }

    @Override
    public <State> void updateVerificationState(VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<State> updater, State state) {
        if (this.isOSRRawStaticAccess()) {
            updater.set(state, this.getFrameSlotIndex(), (byte)1);
        } else {
            updater.set(state, this.getFrameSlotIndex(), (byte)this.getAccessTag());
        }
    }
}

