/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.asm.EntryPointDecorator;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public abstract class TruffleEntryPointDecorator
implements EntryPointDecorator {
    protected MetaAccessProvider metaAccess;
    protected GraalHotSpotVMConfig config;
    protected HotSpotRegistersProvider registers;
    protected final int installedCodeOffset;
    protected final int entryPointOffset;

    public TruffleEntryPointDecorator(MetaAccessProvider metaAccess, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        this.metaAccess = metaAccess;
        this.config = config;
        this.registers = registers;
        ResolvedJavaType optimizedCallTargetType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotOptimizedCallTarget");
        this.installedCodeOffset = TruffleEntryPointDecorator.getFieldOffset("installedCode", optimizedCallTargetType);
        this.entryPointOffset = TruffleEntryPointDecorator.getFieldOffset("entryPoint", TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, InstalledCode.class.getName()));
    }

    private static int getFieldOffset(String name, ResolvedJavaType declaringType) {
        for (ResolvedJavaField field : declaringType.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field.getOffset();
        }
        throw new NoSuchFieldError(declaringType.toJavaName() + "." + name);
    }

    @Override
    public void initialize(CodeGenProviders providers, LIRGenerationResult lirGenRes) {
        if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
            ForeignCallLinkage callTarget = providers.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
            lirGenRes.getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        }
    }
}

