/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common;

import java.lang.ref.WeakReference;
import java.util.Objects;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;

public final class TruffleCompilerAssumptionDependency
implements OptimizedAssumptionDependency {
    private final InstalledCode installedCode;
    private final WeakReference<CompilableTruffleAST> compilableRef;

    public TruffleCompilerAssumptionDependency(CompilableTruffleAST compilation, InstalledCode code) {
        Objects.requireNonNull(code);
        this.installedCode = code;
        this.compilableRef = new WeakReference<CompilableTruffleAST>(compilation);
    }

    @Override
    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        boolean wasActive = false;
        InstalledCode code = this.getInstalledCode();
        if (code != null && code.isAlive()) {
            code.invalidate();
            wasActive = true;
        } else assert (!this.isAlive()) : "Cannot be valid but not alive";
        CompilableTruffleAST ast = (CompilableTruffleAST)this.compilableRef.get();
        if (ast != null) {
            ast.onInvalidate(source, reason, wasActive);
        }
    }

    public InstalledCode getInstalledCode() {
        return this.installedCode;
    }

    @Override
    public CompilableTruffleAST getCompilable() {
        return (CompilableTruffleAST)this.compilableRef.get();
    }

    @Override
    public boolean isAlive() {
        InstalledCode code = this.getInstalledCode();
        if (code == null) {
            return false;
        }
        return code.isAlive();
    }

    public String toString() {
        return "TruffleCompilerAssumptionDependency[" + this.getInstalledCode().toString() + "]";
    }
}

