/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public final class ReverseBitsNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<ReverseBitsNode> TYPE = NodeClass.create(ReverseBitsNode.class);

    public ReverseBitsNode(ValueNode value) {
        super(TYPE, value.stamp(NodeView.DEFAULT).unrestricted(), value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        if (newStamp instanceof IntegerStamp) {
            IntegerStamp valueStamp = (IntegerStamp)newStamp;
            switch (valueStamp.getBits()) {
                case 32: {
                    long mask = CodeUtil.mask((int)32);
                    return IntegerStamp.stampForMask(32, (long)Integer.reverse((int)valueStamp.mustBeSet()) & mask, (long)Integer.reverse((int)valueStamp.mayBeSet()) & mask);
                }
                case 64: {
                    return IntegerStamp.stampForMask(64, Long.reverse(valueStamp.mustBeSet()), Long.reverse(valueStamp.mayBeSet()));
                }
            }
            throw GraalError.unimplemented("Unsupported bit size " + valueStamp.getBits());
        }
        return this.stamp(NodeView.DEFAULT);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue instanceof ReverseBitsNode) {
            return ((ReverseBitsNode)forValue).getValue();
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable result = gen.getLIRGeneratorTool().getArithmetic().emitReverseBits(gen.operand(this.getValue()));
        gen.setResult(this, (Value)result);
    }
}

