/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
public final class HasNegativesNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<HasNegativesNode> TYPE = NodeClass.create(HasNegativesNode.class);
    public static final ForeignCallDescriptor STUB = ForeignCalls.pureFunctionForeignCallDescriptor("stringCodingHasNegatives", Boolean.TYPE, Pointer.class, Integer.TYPE);
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode len;

    public HasNegativesNode(ValueNode array, ValueNode len) {
        this(array, len, null);
    }

    public HasNegativesNode(ValueNode array, ValueNode len, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
        this.array = array;
        this.len = len;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.array, this.len};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitHasNegatives(this.runtimeCheckedCPUFeatures, gen.operand(this.array), gen.operand(this.len)));
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native boolean stringCodingHasNegatives(Pointer var0, int var1);

    @Node.NodeIntrinsic
    public static native boolean stringCodingHasNegatives(Pointer var0, int var1, @Node.ConstantNodeParameter EnumSet<?> var2);
}

