/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class CalcStringAttributesMacroNode
extends MacroNode {
    public static final NodeClass<CalcStringAttributesMacroNode> TYPE = NodeClass.create(CalcStringAttributesMacroNode.class);
    private final LIRGeneratorTool.CalcStringAttributesEncoding encoding;
    private final boolean assumeValid;
    private final LocationIdentity locationIdentity;

    public CalcStringAttributesMacroNode(MacroNode.MacroParams p, LIRGeneratorTool.CalcStringAttributesEncoding encoding, boolean assumeValid, LocationIdentity locationIdentity) {
        this(TYPE, p, encoding, assumeValid, locationIdentity);
    }

    public CalcStringAttributesMacroNode(NodeClass<? extends MacroNode> c, MacroNode.MacroParams p, LIRGeneratorTool.CalcStringAttributesEncoding encoding, boolean assumeValid, LocationIdentity locationIdentity) {
        super(c, p);
        this.encoding = encoding;
        this.assumeValid = assumeValid;
        this.locationIdentity = locationIdentity;
    }

    @Override
    public void lower(LoweringTool tool) {
        Architecture arch = tool.getLowerer().getTarget().arch;
        if (arch instanceof AMD64 && ((AMD64)arch).getFeatures().containsAll(CalcStringAttributesNode.minFeaturesAMD64()) || arch instanceof AArch64 && ((AArch64)arch).getFeatures().containsAll(CalcStringAttributesNode.minFeaturesAARCH64())) {
            CalcStringAttributesNode replacement = this.graph().addOrUnique(new CalcStringAttributesNode(this.getArgument(1), this.getArgument(2), this.getArgument(3), this.encoding, this.assumeValid, this.locationIdentity));
            this.graph().replaceFixedWithFixed(this, replacement);
        } else {
            super.lower(tool);
        }
    }
}

