/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_256)
public class BigIntegerSquareToLenNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<BigIntegerSquareToLenNode> TYPE = NodeClass.create(BigIntegerSquareToLenNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Int)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("squareToLen", Void.TYPE, new Class[]{Pointer.class, Integer.TYPE, Pointer.class, Integer.TYPE}, false, KILLED_LOCATIONS, false, false);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode len;
    @Node.Input
    protected ValueNode z;
    @Node.Input
    protected ValueNode zlen;

    public BigIntegerSquareToLenNode(ValueNode x, ValueNode len, ValueNode z, ValueNode zlen) {
        this(x, len, z, zlen, null);
    }

    public BigIntegerSquareToLenNode(ValueNode x, ValueNode len, ValueNode z, ValueNode zlen, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.x = x;
        this.len = len;
        this.z = z;
        this.zlen = zlen;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.x, this.len, this.z, this.zlen};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="squareToLen")
    public static native void apply(Pointer var0, int var1, Pointer var2, int var3);

    @Node.NodeIntrinsic
    public static native void apply(Pointer var0, int var1, Pointer var2, int var3, @Node.ConstantNodeParameter EnumSet<?> var4);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitBigIntegerSquareToLen(gen.operand(this.x), gen.operand(this.len), gen.operand(this.z), gen.operand(this.zlen));
    }
}

