/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecode;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.replacements.classfile.ClassfileConstant;
import org.graalvm.compiler.replacements.classfile.ClassfileConstantPool;

public class Classfile {
    private final ResolvedJavaType type;
    private final List<ClassfileBytecode> codeAttributes;
    private static final int MAJOR_VERSION_JAVA_MIN = 51;
    private static final int MAJOR_VERSION_JAVA_MAX = 65;
    private static final int MAGIC = -889275714;

    public Classfile(ResolvedJavaType type, DataInputStream stream, ClassfileBytecodeProvider context) throws IOException {
        this.type = type;
        int magic = stream.readInt();
        assert (magic == -889275714);
        int minor = stream.readUnsignedShort();
        int major = stream.readUnsignedShort();
        if (major < 51 || major > 65) {
            throw new UnsupportedClassVersionError("Unsupported class file version: " + major + "." + minor);
        }
        ClassfileConstantPool cp = new ClassfileConstantPool(stream, context);
        Classfile.skipFully(stream, 6);
        Classfile.skipFully(stream, stream.readUnsignedShort() * 2);
        Classfile.skipFields(stream);
        this.codeAttributes = this.readMethods(stream, cp);
        Classfile.skipAttributes(stream);
    }

    public ClassfileBytecode getCode(String name, String descriptor) {
        for (ClassfileBytecode code : this.codeAttributes) {
            ResolvedJavaMethod method = code.getMethod();
            if (!method.getName().equals(name) || !method.getSignature().toMethodDescriptor().equals(descriptor)) continue;
            return code;
        }
        throw new NoSuchMethodError(this.type.toJavaName() + "." + name + descriptor);
    }

    private static void skipAttributes(DataInputStream stream) throws IOException {
        int attributesCount = stream.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            Classfile.skipFully(stream, 2);
            int attributeLength = stream.readInt();
            Classfile.skipFully(stream, attributeLength);
        }
    }

    static void skipFully(DataInputStream stream, int n) throws IOException {
        long skipped = 0L;
        do {
            long s;
            if ((s = stream.skip((long)n - skipped)) != 0L || (skipped += s) == (long)n) continue;
            if (stream.read() == -1) {
                throw new IOException("truncated stream");
            }
            ++skipped;
        } while (skipped != (long)n);
    }

    private ClassfileBytecode findCodeAttribute(DataInputStream stream, ClassfileConstantPool cp, String name, String descriptor, boolean isStatic) throws IOException {
        int attributesCount = stream.readUnsignedShort();
        ClassfileBytecode code = null;
        for (int i = 0; i < attributesCount; ++i) {
            String attributeName = cp.get(ClassfileConstant.Utf8.class, (int)stream.readUnsignedShort()).value;
            int attributeLength = stream.readInt();
            if (code == null && attributeName.equals("Code")) {
                ResolvedJavaMethod method = cp.context.findMethod(this.type, name, descriptor, isStatic);
                code = new ClassfileBytecode(method, stream, cp);
                if (method != null) continue;
                code = null;
                continue;
            }
            Classfile.skipFully(stream, attributeLength);
        }
        return code;
    }

    private static void skipFields(DataInputStream stream) throws IOException {
        int count = stream.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            Classfile.skipFully(stream, 6);
            Classfile.skipAttributes(stream);
        }
    }

    private List<ClassfileBytecode> readMethods(DataInputStream stream, ClassfileConstantPool cp) throws IOException {
        int count = stream.readUnsignedShort();
        ArrayList<ClassfileBytecode> result = new ArrayList<ClassfileBytecode>(count);
        for (int i = 0; i < count; ++i) {
            String name = cp.get(ClassfileConstant.Utf8.class, (int)stream.readUnsignedShort()).value;
            String descriptor = cp.get(ClassfileConstant.Utf8.class, (int)stream.readUnsignedShort()).value;
            int accessFlags = stream.readUnsignedShort();
            boolean isStatic = Modifier.isStatic(accessFlags);
            ClassfileBytecode code = this.findCodeAttribute(stream, cp, name, descriptor, isStatic);
            if (code == null) continue;
            result.add(code);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.type.toJavaName() + ">";
    }
}

