/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import java.util.Arrays;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GetObjectAddressNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class ArrayCopyCallNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill,
MemoryAccess,
Canonicalizable {
    public static final NodeClass<ArrayCopyCallNode> TYPE = NodeClass.create(ArrayCopyCallNode.class);
    @Node.Input
    protected ValueNode src;
    @Node.Input
    protected ValueNode srcPos;
    @Node.Input
    protected ValueNode dest;
    @Node.Input
    protected ValueNode destPos;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;
    private final JavaKind elementKind;
    private final LocationIdentity locationIdentity;
    private final LocationIdentity killedLocationIdentity;
    private final ArrayCopyForeignCalls foreignCalls;
    private final JavaKind wordJavaKind;
    private final int heapWordSize;
    private boolean aligned;
    private boolean disjoint;
    private boolean uninitialized;

    public ArrayCopyCallNode(@Node.InjectedNodeParameter ArrayCopyForeignCalls foreignCalls, @Node.InjectedNodeParameter WordTypes wordTypes, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, boolean aligned, boolean disjoint, boolean uninitialized, int heapWordSize) {
        this(foreignCalls, wordTypes, src, srcPos, dest, destPos, length, elementKind, (LocationIdentity)null, null, aligned, disjoint, uninitialized, heapWordSize);
    }

    public ArrayCopyCallNode(@Node.InjectedNodeParameter ArrayCopyForeignCalls foreignCalls, @Node.InjectedNodeParameter WordTypes wordTypes, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind copyKind, JavaKind srcKind, JavaKind destKind, boolean aligned, boolean disjoint, boolean uninitialized, int heapWordSize) {
        this(foreignCalls, wordTypes, src, srcPos, dest, destPos, length, copyKind, NamedLocationIdentity.getArrayLocation(srcKind), NamedLocationIdentity.getArrayLocation(destKind), aligned, disjoint, uninitialized, heapWordSize);
    }

    public ArrayCopyCallNode(@Node.InjectedNodeParameter ArrayCopyForeignCalls foreignCalls, @Node.InjectedNodeParameter WordTypes wordTypes, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, LocationIdentity killedLocationIdentity, boolean aligned, boolean disjoint, boolean uninitialized, int heapWordSize) {
        this(foreignCalls, wordTypes, src, srcPos, dest, destPos, length, elementKind, null, killedLocationIdentity, aligned, disjoint, uninitialized, heapWordSize);
    }

    public ArrayCopyCallNode(@Node.InjectedNodeParameter ArrayCopyForeignCalls foreignCalls, @Node.InjectedNodeParameter WordTypes wordTypes, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, LocationIdentity locationIdentity, LocationIdentity killedLocationIdentity, boolean aligned, boolean disjoint, boolean uninitialized, int heapWordSize) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forVoid());
        assert (elementKind != null);
        this.src = src;
        this.srcPos = srcPos;
        this.dest = dest;
        this.destPos = destPos;
        this.length = length;
        this.elementKind = elementKind;
        this.locationIdentity = locationIdentity != null ? locationIdentity : NamedLocationIdentity.getArrayLocation(elementKind);
        this.killedLocationIdentity = killedLocationIdentity != null ? killedLocationIdentity : this.locationIdentity;
        this.aligned = aligned;
        this.disjoint = disjoint;
        this.uninitialized = uninitialized;
        this.foreignCalls = foreignCalls;
        this.wordJavaKind = wordTypes.getWordKind();
        this.heapWordSize = heapWordSize;
        assert (!this.getKilledLocationIdentity().equals(LocationIdentity.any()) || this.elementKind.isObject());
    }

    public ValueNode getSource() {
        return this.src;
    }

    public ValueNode getSourcePosition() {
        return this.srcPos;
    }

    public ValueNode getDestination() {
        return this.dest;
    }

    public ValueNode getDestinationPosition() {
        return this.destPos;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public JavaKind getElementKind() {
        return this.elementKind;
    }

    private ValueNode computeBase(LoweringTool tool, ValueNode base, ValueNode pos) {
        FixedWithNextNode basePtr = this.graph().add(new GetObjectAddressNode(base));
        this.graph().addBeforeFixed(this, basePtr);
        Stamp wordStamp = StampFactory.forKind(this.wordJavaKind);
        ValueNode wordPos = IntegerConvertNode.convert(pos, wordStamp, this.graph(), NodeView.DEFAULT);
        int shift = CodeUtil.log2((int)tool.getMetaAccess().getArrayIndexScale(this.elementKind));
        ValueNode scaledIndex = this.graph().unique(new LeftShiftNode(wordPos, ConstantNode.forInt(shift, this.graph())));
        ValueNode offset = this.graph().unique(new AddNode(scaledIndex, ConstantNode.forIntegerStamp(wordStamp, tool.getMetaAccess().getArrayBaseOffset(this.elementKind), this.graph())));
        return this.graph().unique(new OffsetAddressNode(basePtr, offset));
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            this.updateAlignedDisjoint(tool.getMetaAccess());
            ForeignCallDescriptor desc = this.foreignCalls.lookupArraycopyDescriptor(this.elementKind, this.isAligned(), this.isDisjoint(), this.isUninitialized(), this.killedLocationIdentity);
            assert (desc != null) : "no descriptor for arraycopy " + this.elementKind + ", aligned " + this.isAligned() + ", disjoint " + this.isDisjoint() + ", uninit " + this.isUninitialized() + ", killing " + this.killedLocationIdentity;
            StructuredGraph graph = this.graph();
            ValueNode srcAddr = this.computeBase(tool, this.getSource(), this.getSourcePosition());
            ValueNode destAddr = this.computeBase(tool, this.getDestination(), this.getDestinationPosition());
            ValueNode len = this.getLength();
            if (len.stamp(NodeView.DEFAULT).getStackKind() != JavaKind.Long) {
                len = IntegerConvertNode.convert(len, StampFactory.forKind(JavaKind.Long), this.graph(), NodeView.DEFAULT);
            }
            ForeignCallNode call = graph.add(new ForeignCallNode(desc, srcAddr, destAddr, len));
            Object[] callKills = call.getKilledLocationIdentities();
            assert (callKills.length == 1 && callKills[0].equals(this.getKilledLocationIdentity())) : String.format("%s: copy of %s from %s should kill %s, unexpected kills: %s", call, this.elementKind, this.getLocationIdentity(), this.getKilledLocationIdentity(), Arrays.toString(callKills));
            graph.replaceFixedWithFixed(this, call);
        }
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.killedLocationIdentity;
    }

    @Override
    public boolean hasSideEffect() {
        return !this.killedLocationIdentity.isInit();
    }

    @Node.NodeIntrinsic(hasSideEffect=true)
    private static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter JavaKind var5, @Node.ConstantNodeParameter boolean var6, @Node.ConstantNodeParameter boolean var7, @Node.ConstantNodeParameter boolean var8, @Node.ConstantNodeParameter int var9);

    @Node.NodeIntrinsic(hasSideEffect=true)
    private static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter JavaKind var5, @Node.ConstantNodeParameter JavaKind var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter boolean var8, @Node.ConstantNodeParameter boolean var9, @Node.ConstantNodeParameter boolean var10, @Node.ConstantNodeParameter int var11);

    @Node.NodeIntrinsic(hasSideEffect=true)
    private static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter JavaKind var5, @Node.ConstantNodeParameter LocationIdentity var6, @Node.ConstantNodeParameter boolean var7, @Node.ConstantNodeParameter boolean var8, @Node.ConstantNodeParameter boolean var9, @Node.ConstantNodeParameter int var10);

    public static void arraycopyObjectKillsAny(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, JavaKind.Object, LocationIdentity.any(), false, false, false, heapWordSize);
    }

    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter JavaKind elementKind, @Node.ConstantNodeParameter LocationIdentity killedLocationIdentity, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, elementKind, killedLocationIdentity, false, false, false, heapWordSize);
    }

    public static void disjointArraycopy(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter JavaKind elementKind, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, elementKind, false, true, false, heapWordSize);
    }

    public static void disjointArraycopy(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter JavaKind elementKind, @Node.ConstantNodeParameter LocationIdentity killedLocationIdentity, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, elementKind, killedLocationIdentity, false, true, false, heapWordSize);
    }

    public static void disjointArraycopyDifferentKinds(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter JavaKind copyKind, @Node.ConstantNodeParameter JavaKind srcKind, @Node.ConstantNodeParameter JavaKind destKind, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, copyKind, srcKind, destKind, false, true, false, heapWordSize);
    }

    public static void disjointArraycopyKillsInit(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter JavaKind elementKind, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, elementKind, LocationIdentity.init(), false, true, false, heapWordSize);
    }

    public static void disjointUninitializedArraycopy(Object src, int srcPos, Object dest, int destPos, int length, @Node.ConstantNodeParameter JavaKind elementKind, @Node.ConstantNodeParameter int heapWordSize) {
        ArrayCopyCallNode.arraycopy(src, srcPos, dest, destPos, length, elementKind, false, true, true, heapWordSize);
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    boolean isHeapWordAligned(MetaAccessProvider metaAccess, JavaConstant value, JavaKind kind) {
        return ((long)metaAccess.getArrayBaseOffset(kind) + (long)value.asInt() * (long)metaAccess.getArrayIndexScale(kind)) % (long)this.heapWordSize == 0L;
    }

    public void updateAlignedDisjoint(MetaAccessProvider metaAccess) {
        JavaKind componentKind = this.elementKind;
        if (this.srcPos == this.destPos) {
            this.disjoint = true;
        }
        PrimitiveConstant constantSrc = (PrimitiveConstant)this.srcPos.stamp(NodeView.DEFAULT).asConstant();
        PrimitiveConstant constantDst = (PrimitiveConstant)this.destPos.stamp(NodeView.DEFAULT).asConstant();
        if (constantSrc != null && constantDst != null) {
            if (!this.aligned) {
                boolean bl = this.aligned = this.isHeapWordAligned(metaAccess, (JavaConstant)constantSrc, componentKind) && this.isHeapWordAligned(metaAccess, (JavaConstant)constantDst, componentKind);
            }
            if (constantSrc.asInt() >= constantDst.asInt()) {
                this.disjoint = true;
            }
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.getLength().isConstant() && this.getLength().asConstant().isDefaultForKind()) {
            if (this.lastLocationAccess != null) {
                this.replaceAtUsages((Node)this.lastLocationAccess.asNode(), InputType.Memory);
            }
            return null;
        }
        return this;
    }
}

