/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.StringHelperIntrinsics;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.word.LocationIdentity;

public class StringUTF16Snippets
implements Snippets {
    protected static final MetaAccessProvider INJECTED = null;

    private static int length(byte[] value) {
        return value.length >> 1;
    }

    private static long byteArrayCharOffset(long offset) {
        return (long)ReplacementsUtil.byteArrayBaseOffset(INJECTED) + offset * ReplacementsUtil.charArrayIndexScale(INJECTED);
    }

    private static native char getChar(byte[] var0, int var1);

    @Snippet
    public static int indexOfUnsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfUnsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfUnsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= StringUTF16Snippets.length(target), "StringUTF16.indexOfUnsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfUnsafe invalid args: sourceCount < targetCount");
        if (BranchProbabilityNode.unknownProbability(targetCount == 1)) {
            return ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, Stride.S2, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)source, StringUTF16Snippets.byteArrayCharOffset(0L), sourceCount, fromIndex, (int)StringUTF16Snippets.getChar(target, 0));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        int offset = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            int indexOfResult = ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, Stride.S2, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, (Object)source, StringUTF16Snippets.byteArrayCharOffset(0L), haystackLength, offset, (int)StringUTF16Snippets.getChar(target, 0), (int)StringUTF16Snippets.getChar(target, 1));
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            offset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return offset;
            }
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals((Object)source, StringUTF16Snippets.byteArrayCharOffset(offset), (Object)target, StringUTF16Snippets.byteArrayCharOffset(0L), targetCount, JavaKind.Byte, Stride.S2, Stride.S2))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @Snippet
    public static int indexOfLatin1Unsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfLatin1Unsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= target.length, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfLatin1Unsafe invalid args: sourceCount < targetCount");
        if (BranchProbabilityNode.unknownProbability(targetCount == 1)) {
            return ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, Stride.S2, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)source, StringUTF16Snippets.byteArrayCharOffset(0L), sourceCount, fromIndex, (int)((char)Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 0))));
        }
        int offset = fromIndex;
        int haystackLength = sourceCount - (targetCount - 2);
        if (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            char c1 = (char)Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 0));
            char c2 = (char)Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 1));
            do {
                int indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, (indexOfResult = ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, Stride.S2, LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, (Object)source, StringUTF16Snippets.byteArrayCharOffset(0L), haystackLength, offset, (int)c1, (int)c2)) < 0)) {
                    return -1;
                }
                offset = indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                    return offset;
                }
                if (!GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals((Object)source, StringUTF16Snippets.byteArrayCharOffset(offset), (Object)target, StringUTF16Snippets.byteArrayCharOffset(0L), targetCount, JavaKind.Byte, Stride.S2, Stride.S1))) continue;
                return offset;
            } while (GraalDirectives.injectBranchProbability(0.75, ++offset < haystackLength));
        }
        return -1;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo indexOfLatin1Unsafe;
        public final SnippetTemplate.SnippetInfo indexOfUnsafe;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.indexOfLatin1Unsafe = this.snippet(providers, StringUTF16Snippets.class, "indexOfLatin1Unsafe", new LocationIdentity[0]);
            this.indexOfUnsafe = this.snippet(providers, StringUTF16Snippets.class, "indexOfUnsafe", new LocationIdentity[0]);
        }
    }
}

