/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="depends on length")
public final class StringUTF16CompressNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<StringUTF16CompressNode> TYPE = NodeClass.create(StringUTF16CompressNode.class);
    private static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("stringUTF16Compress", Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE}, false, KILLED_LOCATIONS, false, false);
    @Node.Input
    private ValueNode src;
    @Node.Input
    private ValueNode dst;
    @Node.Input
    private ValueNode len;

    public StringUTF16CompressNode(ValueNode src, ValueNode dst, ValueNode len, JavaKind readKind) {
        this(src, dst, len, null, NamedLocationIdentity.getArrayLocation(readKind));
    }

    public StringUTF16CompressNode(ValueNode src, ValueNode dst, ValueNode len) {
        this(src, dst, len, null, LocationIdentity.any());
    }

    public StringUTF16CompressNode(ValueNode src, ValueNode dst, ValueNode len, EnumSet<?> runtimeCheckedCPUFeatures) {
        this(src, dst, len, runtimeCheckedCPUFeatures, LocationIdentity.any());
    }

    private StringUTF16CompressNode(ValueNode src, ValueNode dst, ValueNode len, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(TYPE, IntegerStamp.create(32), runtimeCheckedCPUFeatures, locationIdentity);
        this.src = src;
        this.dst = dst;
        this.len = len;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.src, this.dst, this.len};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lgt = gen.getLIRGeneratorTool();
        Variable res = lgt.emitStringUTF16Compress(this.runtimeCheckedCPUFeatures, gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len));
        gen.setResult(this, (Value)res);
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native int stringUTF16Compress(Pointer var0, Pointer var1, int var2);

    @Node.NodeIntrinsic
    public static native int stringUTF16Compress(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter EnumSet<?> var3);
}

