/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="depends on length")
public final class StringLatin1InflateNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<StringLatin1InflateNode> TYPE = NodeClass.create(StringLatin1InflateNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS_BYTE_CHAR = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Char)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("stringLatin1Inflate", Void.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE}, false, KILLED_LOCATIONS_BYTE_CHAR, false, false);
    @Node.Input
    private ValueNode src;
    @Node.Input
    private ValueNode dst;
    @Node.Input
    private ValueNode len;
    private final LocationIdentity[] killedLocations;

    public StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, JavaKind writeKind) {
        this(src, dst, len, new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(writeKind)}, null);
        GraalError.guarantee(writeKind == JavaKind.Byte || writeKind == JavaKind.Char, "write kind must be either Char or Byte");
    }

    public StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len) {
        this(src, dst, len, KILLED_LOCATIONS_BYTE_CHAR, null);
    }

    public StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, EnumSet<?> runtimeCheckedCPUFeatures) {
        this(src, dst, len, KILLED_LOCATIONS_BYTE_CHAR, runtimeCheckedCPUFeatures);
    }

    private StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, LocationIdentity[] killedLocations, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.killedLocations = killedLocations;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return this.killedLocations;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.src, this.dst, this.len};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitStringLatin1Inflate(this.runtimeCheckedCPUFeatures, gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len));
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native void stringLatin1Inflate(Pointer var0, Pointer var1, int var2);

    @Node.NodeIntrinsic
    public static native void stringLatin1Inflate(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter EnumSet<?> var3);
}

