/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.replacements.SnippetSubstitutionNode;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.nodes.MacroNode;

public abstract class SnippetSubstitutionInvocationPlugin<T extends SnippetTemplate.AbstractTemplates>
extends InvocationPlugin.InlineOnlyInvocationPlugin {
    private final Class<T> templateClass;

    public SnippetSubstitutionInvocationPlugin(Class<T> templateClass, String name, Type ... argumentTypes) {
        super(name, argumentTypes);
        this.templateClass = templateClass;
    }

    public abstract SnippetTemplate.SnippetInfo getSnippet(T var1);

    @Override
    public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] args) {
        SnippetTemplate.AbstractTemplates templates;
        if (!b.isPluginEnabled(this)) {
            return false;
        }
        if (receiver != null) {
            ValueNode r = receiver.get();
            assert (args[0] == r);
        }
        GraalError.guarantee((templates = (SnippetTemplate.AbstractTemplates)b.getReplacements().getSnippetTemplateCache(this.templateClass)) != null, "Missing templates for %s", this.templateClass);
        SnippetTemplate.SnippetInfo snippet = this.getSnippet(templates);
        MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, args);
        SnippetSubstitutionNode node = new SnippetSubstitutionNode(templates, snippet, params);
        node.setConstantArguments(this.getConstantArguments(targetMethod));
        JavaKind returnKind = targetMethod.getSignature().getReturnKind();
        if (returnKind != JavaKind.Void) {
            b.addPush(returnKind, node);
        } else {
            b.add(node);
        }
        return true;
    }

    protected Object[] getConstantArguments(ResolvedJavaMethod targetMethod) {
        return null;
    }
}

