/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_0, cycles=NodeCycles.CYCLES_0, cyclesRationale="This node is immediately removed on next simplification pass")
final class PlaceholderWithExceptionNode
extends WithExceptionNode
implements Simplifiable,
MultiMemoryKill {
    static final NodeClass<PlaceholderWithExceptionNode> TYPE = NodeClass.create(PlaceholderWithExceptionNode.class);
    private final LocationIdentity killedLocation;

    protected PlaceholderWithExceptionNode(LocationIdentity killedLocation) {
        super((NodeClass<? extends WithExceptionNode>)TYPE, StampFactory.forVoid());
        this.killedLocation = killedLocation;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.exceptionEdge != null) {
            this.killExceptionEdge();
        }
        this.graph().removeSplit(this, this.next());
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        if (this.killedLocation != null) {
            return new LocationIdentity[]{this.killedLocation};
        }
        return MemoryKill.MULTI_KILL_NO_LOCATION;
    }
}

