/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugVerifyHandler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;

public class NoDeadCodeVerifyHandler
implements DebugVerifyHandler {
    private static final int OFF = 0;
    private static final int INFO = 1;
    private static final int VERBOSE = 2;
    private static final int FATAL = 3;
    private static final Map<String, Boolean> discovered = new ConcurrentHashMap<String, Boolean>();

    @Override
    public void verify(DebugContext debug, Object object, String format, Object ... args) {
        OptionValues options = debug.getOptions();
        if (Options.NDCV.getValue(options) != 0 && object instanceof StructuredGraph) {
            StructuredGraph graph = (StructuredGraph)object;
            List<Node> before = graph.getNodes().snapshot();
            new DeadCodeEliminationPhase().run(graph);
            List<Node> after = graph.getNodes().snapshot();
            assert (after.size() <= before.size());
            if (before.size() != after.size() && discovered.put(format, Boolean.TRUE) == null) {
                before.removeAll(after);
                Object prefix = format == null ? "" : format + ": ";
                GraalError error = new GraalError("%sfound dead nodes in %s: %s", prefix, graph, before);
                if (Options.NDCV.getValue(options) == 1) {
                    System.out.println(error.getMessage());
                } else if (Options.NDCV.getValue(options) == 2) {
                    error.printStackTrace(System.out);
                } else {
                    assert (Options.NDCV.getValue(options) == 3);
                    throw error;
                }
            }
        }
    }

    static class Options {
        public static final OptionKey<Integer> NDCV = new OptionKey<Integer>(0);

        Options() {
        }
    }
}

