/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.walker;

import java.util.BitSet;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.common.inlining.info.elem.InlineableGraph;
import org.graalvm.compiler.phases.common.inlining.walker.CallsiteHolder;
import org.graalvm.compiler.phases.common.inlining.walker.CallsiteHolderExplorable;

public class MethodInvocation {
    private final InlineInfo callee;
    private final double probability;
    private final double relevance;
    private int processedGraphs;
    private final BitSet freshlyInstantiatedArguments;

    public MethodInvocation(InlineInfo info, double probability, double relevance, BitSet freshlyInstantiatedArguments) {
        this.callee = info;
        this.probability = probability;
        this.relevance = relevance;
        this.freshlyInstantiatedArguments = freshlyInstantiatedArguments;
    }

    public void incrementProcessedGraphs() {
        ++this.processedGraphs;
        assert (this.processedGraphs <= this.callee.numberOfMethods());
    }

    public int processedGraphs() {
        assert (this.processedGraphs <= this.callee.numberOfMethods());
        return this.processedGraphs;
    }

    public int totalGraphs() {
        return this.callee.numberOfMethods();
    }

    public InlineInfo callee() {
        return this.callee;
    }

    public double probability() {
        return this.probability;
    }

    public double relevance() {
        return this.relevance;
    }

    public boolean isRoot() {
        return this.callee == null;
    }

    public CallsiteHolder buildCallsiteHolderForElement(int index) {
        Inlineable elem = this.callee.inlineableElementAt(index);
        assert (elem instanceof InlineableGraph);
        InlineableGraph ig = (InlineableGraph)elem;
        double invokeProbability = this.probability * this.callee.probabilityAt(index);
        double invokeRelevance = this.relevance * this.callee.relevanceAt(index);
        return new CallsiteHolderExplorable(ig.getGraph(), invokeProbability, invokeRelevance, this.freshlyInstantiatedArguments, null);
    }

    public String toString() {
        if (this.isRoot()) {
            return "<root>";
        }
        CallTargetNode callTarget = this.callee.invoke().callTarget();
        if (callTarget instanceof MethodCallTargetNode) {
            ResolvedJavaMethod calleeMethod = ((MethodCallTargetNode)callTarget).targetMethod();
            return calleeMethod.format("Invoke#%H.%n(%p)");
        }
        return "Invoke#" + callTarget.targetName();
    }
}

