/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.walker;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.function.ToDoubleFunction;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.phases.common.inlining.walker.CallsiteHolder;
import org.graalvm.compiler.phases.common.inlining.walker.ComputeInliningRelevance;
import org.graalvm.compiler.phases.common.inlining.walker.InliningIterator;
import org.graalvm.compiler.phases.graph.FixedNodeRelativeFrequencyCache;

public final class CallsiteHolderExplorable
extends CallsiteHolder {
    private final StructuredGraph graph;
    private final LinkedList<Invoke> remainingInvokes;
    private final double probability;
    private final double relevance;
    private final EconomicSet<ParameterNode> fixedParams;
    private final ToDoubleFunction<FixedNode> probabilities;
    private final ComputeInliningRelevance computeInliningRelevance;

    public CallsiteHolderExplorable(StructuredGraph graph, double probability, double relevance, BitSet freshlyInstantiatedArguments, LinkedList<Invoke> invokes) {
        assert (graph != null);
        this.graph = graph;
        this.probability = probability;
        this.relevance = relevance;
        this.fixedParams = this.fixedParamsAt(freshlyInstantiatedArguments);
        LinkedList<Invoke> linkedList = this.remainingInvokes = invokes == null ? new InliningIterator(graph).apply() : invokes;
        if (this.remainingInvokes.isEmpty()) {
            this.probabilities = null;
            this.computeInliningRelevance = null;
        } else {
            this.probabilities = new FixedNodeRelativeFrequencyCache();
            this.computeInliningRelevance = new ComputeInliningRelevance(graph, this.probabilities);
            this.computeProbabilities();
        }
        assert (this.repOK());
    }

    private EconomicSet<ParameterNode> fixedParamsAt(BitSet freshlyInstantiatedArguments) {
        if (freshlyInstantiatedArguments == null || freshlyInstantiatedArguments.isEmpty()) {
            return EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        }
        EconomicSet result = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (ParameterNode p : this.graph.getNodes(ParameterNode.TYPE)) {
            if (!freshlyInstantiatedArguments.get(p.index())) continue;
            result.add((Object)p);
        }
        return result;
    }

    public EconomicSet<ParameterNode> getFixedParams() {
        return this.fixedParams;
    }

    public boolean repOK() {
        for (Invoke invoke : this.remainingInvokes) {
            if (!invoke.asNode().isAlive() || !this.containsInvoke(invoke)) {
                assert (false);
                return false;
            }
            if (CallsiteHolderExplorable.allArgsNonNull(invoke)) continue;
            assert (false);
            return false;
        }
        for (ParameterNode fixedParam : this.fixedParams) {
            if (this.containsParam(fixedParam)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    @Override
    public ResolvedJavaMethod method() {
        return this.graph == null ? null : this.graph.method();
    }

    @Override
    public boolean hasRemainingInvokes() {
        return !this.remainingInvokes.isEmpty();
    }

    @Override
    public StructuredGraph graph() {
        return this.graph;
    }

    public Invoke popInvoke() {
        return this.remainingInvokes.removeFirst();
    }

    public void pushInvoke(Invoke invoke) {
        this.remainingInvokes.push(invoke);
    }

    public static boolean allArgsNonNull(Invoke invoke) {
        for (ValueNode arg : invoke.callTarget().arguments()) {
            if (arg != null) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean containsInvoke(Invoke invoke) {
        for (Invoke i : this.graph().getInvokes()) {
            if (i != invoke) continue;
            return true;
        }
        return false;
    }

    public boolean containsParam(ParameterNode param) {
        for (ParameterNode p : this.graph.getNodes(ParameterNode.TYPE)) {
            if (p != param) continue;
            return true;
        }
        return false;
    }

    public void computeProbabilities() {
        this.computeInliningRelevance.compute();
    }

    public double invokeProbability(Invoke invoke) {
        return this.probability * this.probabilities.applyAsDouble(invoke.asFixedNode());
    }

    public double invokeRelevance(Invoke invoke) {
        return Math.min(1.0, this.relevance) * this.computeInliningRelevance.getRelevance(invoke);
    }

    public String toString() {
        return (this.graph != null ? this.method().format("%H.%n(%p)") : "<null method>") + this.remainingInvokes;
    }
}

