/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.info;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.common.inlining.info.elem.InlineableGraph;
import org.graalvm.compiler.phases.tiers.HighTierContext;

public abstract class AbstractInlineInfo
implements InlineInfo {
    protected final Invoke invoke;

    public AbstractInlineInfo(Invoke invoke) {
        this.invoke = invoke;
    }

    @Override
    public StructuredGraph graph() {
        return this.invoke.asNode().graph();
    }

    @Override
    public Invoke invoke() {
        return this.invoke;
    }

    protected static EconomicSet<Node> inline(Invoke invoke, ResolvedJavaMethod concrete, Inlineable inlineable, boolean receiverNullCheck, String reason) {
        assert (inlineable instanceof InlineableGraph);
        StructuredGraph calleeGraph = ((InlineableGraph)inlineable).getGraph();
        return InliningUtil.inlineForCanonicalization(invoke, calleeGraph, receiverNullCheck, concrete, reason, "InliningPhase");
    }

    @Override
    public final void populateInlinableElements(HighTierContext context, StructuredGraph caller, CanonicalizerPhase canonicalizer, OptionValues options) {
        for (int i = 0; i < this.numberOfMethods(); ++i) {
            Inlineable elem = Inlineable.getInlineableElement(this.methodAt(i), this.invoke, context, canonicalizer, caller.trackNodeSourcePosition());
            this.setInlinableElement(i, elem);
        }
    }

    @Override
    public final int determineNodeCount() {
        int nodes = 0;
        for (int i = 0; i < this.numberOfMethods(); ++i) {
            Inlineable elem = this.inlineableElementAt(i);
            if (elem == null) continue;
            nodes += elem.getNodeCount();
        }
        return nodes;
    }
}

