/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Objects;
import java.util.Optional;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.ConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class IterativeConditionalEliminationPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;
    private final boolean fullSchedule;
    private final ConditionalEliminationPhase conditionalEliminationPhase;

    public IterativeConditionalEliminationPhase(CanonicalizerPhase canonicalizer, boolean fullSchedule) {
        this.canonicalizer = canonicalizer;
        this.fullSchedule = fullSchedule;
        this.conditionalEliminationPhase = new ConditionalEliminationPhase(fullSchedule);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(this.conditionalEliminationPhase.notApplicableTo(graphState), this.canonicalizer.notApplicableTo(graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        int maxIterations = GraalOptions.ConditionalEliminationMaxIterations.getValue(graph.getOptions());
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        int count = 0;
        do {
            ++count;
            try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                this.conditionalEliminationPhase.apply(graph, context);
            }
            if (listener.getNodes().isEmpty()) break;
            this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
            listener.getNodes().clear();
        } while (count < maxIterations);
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().getName(), this.fullSchedule, this.canonicalizer, this.conditionalEliminationPhase);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IterativeConditionalEliminationPhase)) {
            return false;
        }
        IterativeConditionalEliminationPhase that = (IterativeConditionalEliminationPhase)obj;
        return this.getClass().equals(that.getClass()) && this.fullSchedule == that.fullSchedule && this.canonicalizer.equals(that.canonicalizer) && this.conditionalEliminationPhase.equals(that.conditionalEliminationPhase);
    }
}

