/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.MultiGuardNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;

public class InsertGuardFencesPhase
extends Phase {
    public static final IntegerStamp POSITIVE_ARRAY_INDEX_STAMP = IntegerStamp.create(32, 0L, 0x7FFFFFFEL);

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph) {
        ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, false, false, false);
        for (AbstractBeginNode beginNode : graph.getNodes(AbstractBeginNode.TYPE)) {
            if (InsertGuardFencesPhase.hasPotentialUnsafeAccess(cfg, beginNode)) {
                graph.getDebug().log(3, "Adding speculation fence at %s because of unguarded fixed access", (Object)beginNode);
                beginNode.setHasSpeculationFence();
                continue;
            }
            if (InsertGuardFencesPhase.hasGuardUsages(beginNode)) {
                if (SpectrePHTMitigations.Options.SpectrePHTBarriers.getValue(graph.getOptions()) == SpectrePHTMitigations.NonDeoptGuardTargets && InsertGuardFencesPhase.isDeoptGuard(beginNode)) {
                    graph.getDebug().log(3, "Skipping deoptimizing guard speculation fence at %s", (Object)beginNode);
                    continue;
                }
                if (SpectrePHTMitigations.Options.SpectrePHTIndexMasking.getValue(graph.getOptions()).booleanValue() && InsertGuardFencesPhase.isBoundsCheckGuard(beginNode)) {
                    graph.getDebug().log(3, "Skipping bounds-check speculation fence at %s", (Object)beginNode);
                    continue;
                }
                if (graph.getDebug().isLogEnabled(4)) {
                    graph.getDebug().log(4, "Adding speculation fence for %s at %s", InsertGuardFencesPhase.guardUsages(beginNode), (Object)beginNode);
                } else {
                    graph.getDebug().log(3, "Adding speculation fence at %s", (Object)beginNode);
                }
                beginNode.setHasSpeculationFence();
                continue;
            }
            graph.getDebug().log(4, "No guards on %s", (Object)beginNode);
        }
    }

    private static boolean hasPotentialUnsafeAccess(ControlFlowGraph cfg, AbstractBeginNode beginNode) {
        for (FixedNode n : cfg.blockFor(beginNode).getNodes()) {
            if (!(n instanceof FixedAccessNode) || ((FixedAccessNode)n).getGuard() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeoptGuard(AbstractBeginNode beginNode) {
        AbstractBeginNode otherBegin;
        if (!(beginNode.predecessor() instanceof IfNode)) {
            return false;
        }
        IfNode ifNode = (IfNode)beginNode.predecessor();
        if (ifNode.trueSuccessor() == beginNode) {
            otherBegin = ifNode.falseSuccessor();
        } else {
            assert (ifNode.falseSuccessor() == beginNode);
            otherBegin = ifNode.trueSuccessor();
        }
        if (!(otherBegin.next() instanceof DeoptimizeNode)) {
            return false;
        }
        DeoptimizeNode deopt = (DeoptimizeNode)otherBegin.next();
        return deopt.getAction().doesInvalidateCompilation();
    }

    private static boolean isBoundsCheckGuard(AbstractBeginNode beginNode) {
        DeoptimizeNode deopt;
        AbstractBeginNode otherBegin;
        if (!(beginNode.predecessor() instanceof IfNode)) {
            return false;
        }
        IfNode ifNode = (IfNode)beginNode.predecessor();
        if (ifNode.trueSuccessor() == beginNode) {
            otherBegin = ifNode.falseSuccessor();
        } else {
            assert (ifNode.falseSuccessor() == beginNode);
            otherBegin = ifNode.trueSuccessor();
        }
        if (otherBegin.next() instanceof DeoptimizeNode ? (deopt = (DeoptimizeNode)otherBegin.next()).getReason() == DeoptimizationReason.BoundsCheckException && !InsertGuardFencesPhase.hasMultipleGuardUsages(beginNode) : otherBegin instanceof LoopExitNode && beginNode.usages().filter(MultiGuardNode.class).isNotEmpty() && !InsertGuardFencesPhase.hasMultipleGuardUsages(beginNode)) {
            return true;
        }
        block0: for (Node usage : beginNode.usages()) {
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != InputType.Guard || pos.get(usage) != beginNode) continue;
                if (usage instanceof PiNode) {
                    if (((PiNode)usage).piStamp().equals(POSITIVE_ARRAY_INDEX_STAMP)) continue block0;
                    return false;
                }
                if (usage instanceof MemoryAccess) {
                    if (NamedLocationIdentity.isArrayLocation(((MemoryAccess)((Object)usage)).getLocationIdentity())) continue block0;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean hasGuardUsages(Node n) {
        for (Node usage : n.usages()) {
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != InputType.Guard || pos.get(usage) != n) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasMultipleGuardUsages(Node n) {
        boolean foundOne = false;
        for (Node usage : n.usages()) {
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != InputType.Guard || pos.get(usage) != n) continue;
                if (foundOne) {
                    return true;
                }
                foundOne = true;
            }
        }
        return false;
    }

    private static List<Node> guardUsages(Node n) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node usage : n.usages()) {
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != InputType.Guard || pos.get(usage) != n) continue;
                ret.add(usage);
            }
        }
        return ret;
    }
}

