/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.ListIterator;
import java.util.Optional;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BinaryOpLogicNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnaryOpLogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.graph.ScheduledNodeIterator;
import org.graalvm.compiler.phases.util.Providers;

public class FixReadsPhase
extends BasePhase<CoreProviders> {
    private static final CounterKey counterStampsRegistered = DebugContext.counter("FixReads_StampsRegistered");
    private static final CounterKey counterBetterMergedStamps = DebugContext.counter("FixReads_BetterMergedStamp");
    protected final boolean replaceInputsWithConstants;
    protected final BasePhase<? super CoreProviders> schedulePhase;

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    public FixReadsPhase(boolean replaceInputsWithConstants, BasePhase<? super CoreProviders> schedulePhase) {
        this.replaceInputsWithConstants = replaceInputsWithConstants;
        this.schedulePhase = schedulePhase;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.FIXED_READS, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.LOW_TIER_LOWERING, graphState), BasePhase.NotApplicable.when(graphState.getGuardsStage().areFrameStatesAtSideEffects(), "This phase must run after FSA"));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        assert (graph.verify());
        this.schedulePhase.apply(graph, context);
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        FixReadsClosure fixReadsClosure = new FixReadsClosure(graph);
        for (HIRBlock block : schedule.getCFG().getBlocks()) {
            fixReadsClosure.processNodes(block, schedule);
        }
        assert (graph.verify());
        if (GraalOptions.RawConditionalElimination.getValue(graph.getOptions()).booleanValue()) {
            schedule.getCFG().visitDominatorTree(this.createVisitor(graph, schedule, context), false);
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.FIXED_READS);
    }

    protected ControlFlowGraph.RecursiveVisitor<?> createVisitor(StructuredGraph graph, StructuredGraph.ScheduleResult schedule, CoreProviders context) {
        return new RawConditionalEliminationVisitor(graph, schedule, context.getMetaAccess(), this.replaceInputsWithConstants);
    }

    public BasePhase<? super CoreProviders> getSchedulePhase() {
        return this.schedulePhase;
    }

    private static class FixReadsClosure
    extends ScheduledNodeIterator {
        private final NodeBitMap inferStampBitmap;

        FixReadsClosure(StructuredGraph graph) {
            this.inferStampBitmap = graph.createNodeBitMap();
        }

        @Override
        protected void processNode(Node node, HIRBlock block, StructuredGraph.ScheduleResult schedule, ListIterator<Node> iter) {
            ValueNode valueNode;
            if (this.inferStampBitmap.isMarked(node) && node instanceof ValueNode && (valueNode = (ValueNode)node).inferStamp()) {
                for (Node n : valueNode.usages()) {
                    this.inferStampBitmap.mark(n);
                }
            }
            if (node instanceof AbstractMergeNode) {
                AbstractMergeNode mergeNode = (AbstractMergeNode)node;
                for (MemoryPhiNode memoryPhi : mergeNode.memoryPhis().snapshot()) {
                    memoryPhi.replaceAtUsages(null);
                    memoryPhi.safeDelete();
                }
            } else if (node instanceof FloatingAccessNode) {
                FloatingAccessNode floatingAccessNode = (FloatingAccessNode)node;
                floatingAccessNode.setLastLocationAccess(null);
                GuardingNode guard = floatingAccessNode.getGuard();
                if (guard != null) {
                    floatingAccessNode.setGuard(null);
                    GraphUtil.tryKillUnused(guard.asNode());
                }
                FixedAccessNode fixedAccess = floatingAccessNode.asFixedNode();
                this.replaceCurrent(fixedAccess);
            } else if (node instanceof PiNode) {
                PiNode piNode = (PiNode)node;
                if (piNode.stamp(NodeView.DEFAULT).isCompatible(piNode.getOriginalNode().stamp(NodeView.DEFAULT))) {
                    for (Node n : piNode.usages()) {
                        this.inferStampBitmap.mark(n);
                    }
                    piNode.replaceAndDelete(piNode.getOriginalNode());
                }
            } else if (node instanceof MemoryAccess) {
                MemoryAccess memoryAccess = (MemoryAccess)((Object)node);
                memoryAccess.setLastLocationAccess(null);
            }
        }
    }

    public static class RawConditionalEliminationVisitor
    implements ControlFlowGraph.RecursiveVisitor<Integer> {
        protected final NodeMap<StampElement> stampMap;
        protected final NodeStack undoOperations;
        private final StructuredGraph.ScheduleResult schedule;
        private final StructuredGraph graph;
        private final MetaAccessProvider metaAccess;
        private final boolean replaceConstantInputs;
        private final BlockMap<Integer> blockActionStart;
        private final EconomicMap<MergeNode, EconomicMap<ValueNode, Stamp>> endMaps;
        private final DebugContext debug;
        private final RawCanonicalizerTool rawCanonicalizerTool;
        private final EconomicMap<Node, HIRBlock> nodeToBlockMap;

        public RawConditionalEliminationVisitor(StructuredGraph graph, StructuredGraph.ScheduleResult schedule, MetaAccessProvider metaAccess, boolean replaceInputsWithConstants) {
            this.graph = graph;
            this.debug = graph.getDebug();
            this.schedule = schedule;
            this.metaAccess = metaAccess;
            this.rawCanonicalizerTool = new RawCanonicalizerTool(new Providers(metaAccess, null, null, null, null, null, null, null, null, null, null, null, null));
            this.blockActionStart = new BlockMap(schedule.getCFG());
            this.endMaps = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            this.stampMap = graph.createNodeMap();
            this.undoOperations = new NodeStack();
            this.replaceConstantInputs = replaceInputsWithConstants && GraalOptions.ReplaceInputsWithConstantsBasedOnStamps.getValue(graph.getOptions()) != false;
            this.nodeToBlockMap = EconomicMap.create();
        }

        protected void replaceInput(Position p, Node oldInput, Node newConstantInput) {
            p.set(oldInput, newConstantInput);
        }

        protected int replaceConstantInputs(Node node) {
            int replacements = 0;
            for (Position p : node.inputPositions()) {
                FloatStamp floatStamp;
                Stamp bestStamp;
                Constant constant;
                ValueNode valueNode;
                Node input = p.get(node);
                if (p.getInputType() != InputType.Value || !(input instanceof ValueNode) || (valueNode = (ValueNode)input) instanceof ConstantNode || (constant = (bestStamp = this.getBestStamp(valueNode)).asConstant()) == null || bestStamp instanceof FloatStamp && (floatStamp = (FloatStamp)bestStamp).contains(0.0)) continue;
                ConstantNode stampConstant = ConstantNode.forConstant(bestStamp, constant, this.metaAccess, this.graph);
                assert (stampConstant.stamp(NodeView.DEFAULT).isCompatible(valueNode.stamp(NodeView.DEFAULT)));
                this.replaceInput(p, node, stampConstant);
                this.graph.getOptimizationLog().report(FixReadsPhase.class, "ConstantInputReplacement", node);
                ++replacements;
            }
            return replacements;
        }

        private static boolean nonNullAndDominates(HIRBlock a, HIRBlock b) {
            if (a == null) {
                return false;
            }
            return a.dominates(b);
        }

        protected void processNode(Node node, HIRBlock b, NodePredicate nodePredicate) {
            Node dominatingDuplicate;
            assert (node.isAlive());
            if (this.replaceConstantInputs) {
                this.replaceConstantInputs(node);
            }
            if (node.getNodeClass().valueNumberable() && (dominatingDuplicate = this.graph.findDuplicate(node, nodePredicate)) != null) {
                node.replaceAndDelete(dominatingDuplicate);
                return;
            }
            if (node instanceof MergeNode) {
                this.registerCombinedStamps((MergeNode)node);
            }
            if (node instanceof AbstractBeginNode) {
                this.processAbstractBegin((AbstractBeginNode)node);
            } else if (node instanceof IfNode) {
                this.processIf((IfNode)node);
            } else if (node instanceof IntegerSwitchNode) {
                this.processIntegerSwitch((IntegerSwitchNode)node);
            } else if (node instanceof BinaryNode) {
                this.processBinary((BinaryNode)node, b, nodePredicate);
            } else if (node instanceof ConditionalNode) {
                this.processConditional((ConditionalNode)node);
            } else if (node instanceof UnaryNode) {
                this.processUnary((UnaryNode)node, b, nodePredicate);
            } else if (node instanceof EndNode) {
                this.processEnd((EndNode)node);
            }
            if (node.getNodeClass().valueNumberable() && node.isAlive()) {
                this.nodeToBlockMap.put((Object)node, (Object)b);
            }
        }

        protected void registerCombinedStamps(MergeNode node) {
            EconomicMap endMap = (EconomicMap)this.endMaps.get((Object)node);
            MapCursor entries = endMap.getEntries();
            while (entries.advance()) {
                ValueNode value = (ValueNode)entries.getKey();
                if (value.isDeleted() || !this.registerNewValueStamp(value, (Stamp)entries.getValue())) continue;
                counterBetterMergedStamps.increment(this.debug);
            }
        }

        protected void processEnd(EndNode node) {
            AbstractMergeNode abstractMerge = node.merge();
            if (abstractMerge instanceof MergeNode) {
                MergeNode merge = (MergeNode)abstractMerge;
                NodeMap<HIRBlock> blockToNodeMap = this.schedule.getNodeToBlockMap();
                HIRBlock mergeBlock = blockToNodeMap.get(merge);
                HIRBlock mergeBlockDominator = (HIRBlock)mergeBlock.getDominator();
                HIRBlock currentBlock = blockToNodeMap.get(node);
                EconomicMap currentEndMap = (EconomicMap)this.endMaps.get((Object)merge);
                if (currentEndMap == null || !currentEndMap.isEmpty()) {
                    EconomicMap endMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                    for (ValuePhiNode phi : merge.valuePhis()) {
                        if (currentEndMap != null && !currentEndMap.containsKey((Object)phi)) continue;
                        ValueNode valueAt = phi.valueAt(node);
                        Stamp bestStamp = this.getBestStamp(valueAt);
                        if (currentEndMap != null) {
                            bestStamp = bestStamp.meet((Stamp)currentEndMap.get((Object)phi));
                        }
                        if (bestStamp.equals(phi.stamp(NodeView.DEFAULT))) continue;
                        endMap.put((Object)phi, (Object)bestStamp);
                    }
                    int lastMark = this.undoOperations.size();
                    while (currentBlock != mergeBlockDominator) {
                        int mark = this.blockActionStart.get(currentBlock);
                        for (int i = lastMark - 1; i >= mark; --i) {
                            HIRBlock block;
                            ValueNode nodeWithNewStamp = (ValueNode)this.undoOperations.get(i);
                            if (nodeWithNewStamp.isDeleted() || nodeWithNewStamp instanceof LogicNode || nodeWithNewStamp instanceof ConstantNode || blockToNodeMap.isNew(nodeWithNewStamp) || (block = RawConditionalEliminationVisitor.getBlock(nodeWithNewStamp, blockToNodeMap)) != null && block.getId() > mergeBlockDominator.getId()) continue;
                            Stamp bestStamp = this.getBestStamp(nodeWithNewStamp);
                            assert (bestStamp != null);
                            if (currentEndMap != null) {
                                Stamp otherEndsStamp = (Stamp)currentEndMap.get((Object)nodeWithNewStamp);
                                if (otherEndsStamp == null) continue;
                                bestStamp = bestStamp.meet(otherEndsStamp);
                            }
                            if (nodeWithNewStamp.stamp(NodeView.DEFAULT).tryImproveWith(bestStamp) == null) continue;
                            endMap.put((Object)nodeWithNewStamp, (Object)bestStamp);
                        }
                        currentBlock = (HIRBlock)currentBlock.getDominator();
                    }
                    this.endMaps.put((Object)merge, (Object)endMap);
                }
            }
        }

        private static HIRBlock getBlock(ValueNode node, NodeMap<HIRBlock> blockToNodeMap) {
            if (node instanceof PhiNode) {
                PhiNode phiNode = (PhiNode)node;
                return blockToNodeMap.get(phiNode.merge());
            }
            return blockToNodeMap.get(node);
        }

        protected void processUnary(UnaryNode node, HIRBlock block, NodePredicate gvnPredicate) {
            ValueNode value = node.getValue();
            Stamp bestStamp = this.getBestStamp(value);
            Stamp newStamp = node.foldStamp(bestStamp);
            if (!this.checkReplaceWithConstant(newStamp, node)) {
                ValueNode newNode;
                if (!bestStamp.equals(value.stamp(NodeView.DEFAULT)) && (newNode = (ValueNode)node.canonical(this.rawCanonicalizerTool)) != node) {
                    if (newNode != null && !newNode.isAlive()) {
                        newNode = this.addHelper(newNode, block, gvnPredicate);
                    }
                    node.replaceAndDelete(newNode);
                    GraphUtil.tryKillUnused(value);
                    return;
                }
                this.registerNewValueStamp(node, newStamp);
            }
        }

        private ValueNode addHelper(ValueNode newNode, HIRBlock block, NodePredicate gvnPredicate) {
            Graph.Mark m = this.graph.getMark();
            ValueNode result = this.graph.addOrUniqueWithInputs(newNode, gvnPredicate);
            for (Node n : this.graph.getNewNodes(m)) {
                this.nodeToBlockMap.put((Object)n, (Object)block);
            }
            return result;
        }

        protected boolean checkReplaceWithConstant(Stamp newStamp, ValueNode node) {
            Constant constant = newStamp.asConstant();
            if (constant != null && !(node instanceof ConstantNode)) {
                ConstantNode stampConstant = ConstantNode.forConstant(newStamp, constant, this.metaAccess, this.graph);
                node.replaceAtUsages((Node)stampConstant, InputType.Value);
                this.graph.getOptimizationLog().report(FixReadsPhase.class, "ConstantReplacement", node);
                GraphUtil.tryKillUnused(node);
                return true;
            }
            return false;
        }

        protected void processBinary(BinaryNode node, HIRBlock b, NodePredicate nodePredicate) {
            Stamp yStamp;
            ValueNode x = node.getX();
            ValueNode y = node.getY();
            Stamp xStamp = this.getBestStamp(x);
            Stamp newStamp = node.foldStamp(xStamp, yStamp = this.getBestStamp(y));
            if (!this.checkReplaceWithConstant(newStamp, node)) {
                ValueNode newNode;
                if (!(xStamp.equals(x.stamp(NodeView.DEFAULT)) && yStamp.equals(y.stamp(NodeView.DEFAULT)) || (newNode = (ValueNode)node.canonical(this.rawCanonicalizerTool)) == node)) {
                    if (newNode != null && !newNode.isAlive()) {
                        newNode = this.addHelper(newNode, b, nodePredicate);
                    }
                    node.replaceAndDelete(newNode);
                    GraphUtil.tryKillUnused(x);
                    GraphUtil.tryKillUnused(y);
                    this.graph.getOptimizationLog().report(FixReadsPhase.class, "BinaryCanonicalization", node);
                    return;
                }
                this.registerNewValueStamp(node, newStamp);
            }
        }

        protected void processIntegerSwitch(IntegerSwitchNode node) {
            Stamp bestStamp = this.getBestStamp(node.value());
            if (node.tryRemoveUnreachableKeys(null, bestStamp)) {
                this.graph.getOptimizationLog().report(FixReadsPhase.class, "SwitchCanonicalization", node);
            }
        }

        protected void processIf(IfNode node) {
            TriState result = this.tryProveCondition(node.condition());
            if (result != TriState.UNKNOWN) {
                boolean isTrue = result == TriState.TRUE;
                node.setCondition(LogicConstantNode.forBoolean(isTrue, node.graph()));
                this.graph.getOptimizationLog().report(FixReadsPhase.class, "IfElimination", node);
            }
        }

        protected void processConditional(ConditionalNode node) {
            TriState result = this.tryProveCondition(node.condition());
            if (result != TriState.UNKNOWN) {
                boolean isTrue = result == TriState.TRUE;
                node.replaceAndDelete(isTrue ? node.trueValue() : node.falseValue());
                this.graph.getOptimizationLog().report(FixReadsPhase.class, "ConditionalElimination", node);
            } else {
                Stamp trueStamp = this.getBestStamp(node.trueValue());
                Stamp falseStamp = this.getBestStamp(node.falseValue());
                this.registerNewStamp(node, trueStamp.meet(falseStamp));
            }
        }

        protected TriState tryProveCondition(LogicNode condition) {
            Stamp conditionStamp = this.getBestStamp(condition);
            if (conditionStamp == StampFactory.tautology()) {
                return TriState.TRUE;
            }
            if (conditionStamp == StampFactory.contradiction()) {
                return TriState.FALSE;
            }
            if (condition instanceof UnaryOpLogicNode) {
                UnaryOpLogicNode unaryOpLogicNode = (UnaryOpLogicNode)condition;
                return unaryOpLogicNode.tryFold(this.getBestStamp(unaryOpLogicNode.getValue()));
            }
            if (condition instanceof BinaryOpLogicNode) {
                BinaryOpLogicNode binaryOpLogicNode = (BinaryOpLogicNode)condition;
                return binaryOpLogicNode.tryFold(this.getBestStamp(binaryOpLogicNode.getX()), this.getBestStamp(binaryOpLogicNode.getY()));
            }
            return TriState.UNKNOWN;
        }

        protected void processAbstractBegin(AbstractBeginNode beginNode) {
            Node predecessor = beginNode.predecessor();
            if (predecessor instanceof IfNode) {
                IfNode ifNode = (IfNode)predecessor;
                boolean negated = ifNode.falseSuccessor() == beginNode;
                LogicNode condition = ifNode.condition();
                this.registerNewCondition(condition, negated);
            } else if (predecessor instanceof IntegerSwitchNode) {
                IntegerSwitchNode integerSwitchNode = (IntegerSwitchNode)predecessor;
                this.registerIntegerSwitch(beginNode, integerSwitchNode);
            }
        }

        private void registerIntegerSwitch(AbstractBeginNode beginNode, IntegerSwitchNode integerSwitchNode) {
            this.registerNewValueStamp(integerSwitchNode.value(), integerSwitchNode.getValueStampForSuccessor(beginNode));
        }

        protected void registerNewCondition(LogicNode condition, boolean negated) {
            if (condition instanceof UnaryOpLogicNode) {
                UnaryOpLogicNode unaryLogicNode = (UnaryOpLogicNode)condition;
                ValueNode value = unaryLogicNode.getValue();
                Stamp newStamp = unaryLogicNode.getSucceedingStampForValue(negated);
                this.registerNewValueStamp(value, newStamp);
            } else if (condition instanceof BinaryOpLogicNode) {
                BinaryOpLogicNode binaryOpLogicNode = (BinaryOpLogicNode)condition;
                ValueNode x = binaryOpLogicNode.getX();
                ValueNode y = binaryOpLogicNode.getY();
                Stamp xStamp = this.getBestStamp(x);
                Stamp yStamp = this.getBestStamp(y);
                this.registerNewValueStamp(x, binaryOpLogicNode.getSucceedingStampForX(negated, xStamp, yStamp));
                this.registerNewValueStamp(y, binaryOpLogicNode.getSucceedingStampForY(negated, xStamp, yStamp));
            }
            this.registerCondition(condition, negated);
        }

        protected void registerCondition(LogicNode condition, boolean negated) {
            this.registerNewStamp(condition, negated ? StampFactory.contradiction() : StampFactory.tautology());
        }

        protected boolean registerNewValueStamp(ValueNode value, Stamp newStamp) {
            Stamp currentStamp;
            Stamp betterStamp;
            if (newStamp != null && !value.isConstant() && (betterStamp = (currentStamp = this.getBestStamp(value)).tryImproveWith(newStamp)) != null) {
                this.registerNewStamp(value, betterStamp);
                return true;
            }
            return false;
        }

        protected void registerNewStamp(ValueNode value, Stamp newStamp) {
            counterStampsRegistered.increment(this.debug);
            this.debug.log("\t Saving stamp for node %s stamp %s", (Object)value, (Object)newStamp);
            ValueNode originalNode = value;
            this.stampMap.setAndGrow(originalNode, new StampElement(newStamp, this.stampMap.getAndGrow(originalNode)));
            this.undoOperations.push(originalNode);
        }

        protected Stamp getBestStamp(ValueNode value) {
            ValueNode originalNode = value;
            if (!value.isAlive()) {
                return value.stamp(NodeView.DEFAULT);
            }
            StampElement currentStamp = this.stampMap.getAndGrow(originalNode);
            if (currentStamp == null) {
                return value.stamp(NodeView.DEFAULT);
            }
            return currentStamp.getStamp();
        }

        @Override
        public Integer enter(HIRBlock b) {
            int mark = this.undoOperations.size();
            this.blockActionStart.put(b, mark);
            NodePredicate nodePredicate = n -> RawConditionalEliminationVisitor.nonNullAndDominates((HIRBlock)this.nodeToBlockMap.get((Object)n), b);
            for (Node n2 : this.schedule.getBlockToNodesMap().get(b)) {
                if (!n2.isAlive()) continue;
                this.processNode(n2, b, nodePredicate);
            }
            return mark;
        }

        @Override
        public void exit(HIRBlock b, Integer state) {
            int mark = state;
            while (this.undoOperations.size() > mark) {
                Node node = this.undoOperations.pop();
                if (!node.isAlive()) continue;
                this.stampMap.set(node, this.stampMap.get(node).getParent());
            }
        }

        private class RawCanonicalizerTool
        extends CoreProvidersDelegate
        implements NodeView,
        CanonicalizerTool {
            RawCanonicalizerTool(CoreProviders providers) {
                super(providers);
            }

            @Override
            public Assumptions getAssumptions() {
                return RawConditionalEliminationVisitor.this.graph.getAssumptions();
            }

            @Override
            public boolean canonicalizeReads() {
                return false;
            }

            @Override
            public boolean allUsagesAvailable() {
                return true;
            }

            @Override
            public Integer smallestCompareWidth() {
                return null;
            }

            @Override
            public boolean supportsRounding() {
                return false;
            }

            @Override
            public OptionValues getOptions() {
                return RawConditionalEliminationVisitor.this.graph.getOptions();
            }

            @Override
            public Stamp stamp(ValueNode node) {
                return RawConditionalEliminationVisitor.this.getBestStamp(node);
            }

            @Override
            public boolean divisionOverflowIsJVMSCompliant() {
                return false;
            }
        }
    }

    protected static final class StampElement {
        private final Stamp stamp;
        private final StampElement parent;

        public StampElement(Stamp stamp, StampElement parent) {
            this.stamp = stamp;
            this.parent = parent;
        }

        public StampElement getParent() {
            return this.parent;
        }

        public Stamp getStamp() {
            return this.stamp;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.stamp);
            if (this.parent != null) {
                result.append(" (");
                result.append(this.parent);
                result.append(")");
            }
            return result.toString();
        }
    }
}

