/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.spi.NodeWithIdentity;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.FixedBinaryNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.cfg.LocationSet;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.PostRunCanonicalizationPhase;
import org.graalvm.compiler.phases.util.GraphOrder;
import org.graalvm.word.LocationIdentity;

public class DominatorBasedGlobalValueNumberingPhase
extends PostRunCanonicalizationPhase<CoreProviders> {
    public static final CounterKey earlyGVN = DebugContext.counter("EarlyGVN");
    public static final CounterKey earlyGVNLICM = DebugContext.counter("EarlyGVN_LICM");
    public static final CounterKey earlyGVNAbort = DebugContext.counter("EarlyGVN_AbortProxy");

    public DominatorBasedGlobalValueNumberingPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DominatorBasedGlobalValueNumberingPhase.runFixedNodeGVN(graph, context);
        assert (DominatorBasedGlobalValueNumberingPhase.verifyGVN(graph));
    }

    private static void runFixedNodeGVN(StructuredGraph graph, CoreProviders context) {
        LoopsData ld = context.getLoopsDataProvider().getLoopsData(graph);
        ld.getCFG().visitDominatorTreeDefault(new GVNVisitor(ld.getCFG(), ld));
    }

    private static boolean verifyGVN(StructuredGraph graph) {
        assert (GraphOrder.assertNonCyclicGraph(graph));
        return true;
    }

    public static boolean canGVN(Node n) {
        return !MemoryKill.isMemoryKill(n) && (n instanceof MemoryAccess || n instanceof FixedGuardNode || n instanceof FixedBinaryNode) && !(n instanceof ControlFlowAnchored) && !(n instanceof AnchoringNode) && !(n instanceof NodeWithIdentity);
    }

    public static boolean tryPerformLICM(LoopEx loop, FixedNode n, NodeBitMap liftedNodes) {
        if (DominatorBasedGlobalValueNumberingPhase.nodeCanBeLifted(n, loop, liftedNodes)) {
            loop.loopBegin().getDebug().dump(5, (Object)loop.loopBegin().graph(), "Before LICM of node %s", n);
            loop.loopBegin().getDebug().log(5, "Early GVN: LICM on node %s", (Object)n);
            FixedWithNextNode toLift = (FixedWithNextNode)n;
            FixedNode next = ((FixedWithNextNode)n).next();
            FixedWithNextNode fwn = (FixedWithNextNode)toLift.predecessor();
            fwn.setNext(null);
            toLift.setNext(null);
            fwn.setNext(next);
            n.graph().addBeforeFixed(loop.loopBegin().forwardEnd(), toLift);
            liftedNodes.checkAndMarkInc(toLift);
            loop.loopBegin().getDebug().dump(5, loop.loopBegin().graph(), "After LICM of node %s for loop %s", n, loop);
            earlyGVNLICM.increment(loop.loopBegin().getDebug());
            if (loop.loopBegin().getDebug().isCountEnabled()) {
                DebugContext.counter(earlyGVNLICM.getName() + "_" + n.getClass().getSimpleName()).increment(n.graph().getDebug());
            }
            return true;
        }
        return false;
    }

    public static boolean nodeCanBeLifted(Node n, LoopEx loop, NodeBitMap liftedNodes) {
        boolean canLICM = true;
        for (Node input : n.inputs()) {
            if ((input instanceof LogicNode || input instanceof PiNode) && !DominatorBasedGlobalValueNumberingPhase.inputIsLoopInvariant(input, loop, liftedNodes)) {
                boolean isActuallyLI = true;
                for (Node floatingInput : input.inputs()) {
                    isActuallyLI &= DominatorBasedGlobalValueNumberingPhase.inputIsLoopInvariant(floatingInput, loop, liftedNodes);
                }
                if (isActuallyLI) {
                    liftedNodes.mark(input);
                }
            }
            canLICM &= DominatorBasedGlobalValueNumberingPhase.inputIsLoopInvariant(input, loop, liftedNodes);
        }
        return canLICM;
    }

    public static boolean inputIsLoopInvariant(Node input, LoopEx loop, NodeBitMap liftedNodes) {
        if (input == null) {
            return true;
        }
        return !loop.whole().contains(input) || liftedNodes.contains(input);
    }

    public static boolean loopKillsLocation(LocationSet thisLoopKilledLocations, LocationIdentity loc) {
        if (thisLoopKilledLocations == null) {
            return false;
        }
        return thisLoopKilledLocations.containsOrOverlaps(loc);
    }

    protected static class GVNVisitor
    implements ControlFlowGraph.RecursiveVisitor<ValueMap> {
        final StructuredGraph graph;
        final ControlFlowGraph cfg;
        final LoopsData ld;
        final NodeBitMap licmNodes;
        final BlockMap<ValueMap> blockMaps;
        final boolean considerLICM;

        public GVNVisitor(ControlFlowGraph cfg, LoopsData ld) {
            this.cfg = cfg;
            this.ld = ld;
            this.graph = cfg.graph;
            this.licmNodes = this.graph.createNodeBitMap();
            this.blockMaps = new BlockMap(cfg);
            this.considerLICM = GraalOptions.EarlyLICM.getValue(this.graph.getOptions()) != false && this.graph.hasLoops();
        }

        @Override
        public ValueMap enter(HIRBlock b) {
            LocationSet thisLoopKilledLocations;
            ValueMap blockMap = this.blockMaps.get(b);
            assert (blockMap == null);
            HIRBlock dominator = (HIRBlock)b.getDominator();
            if (dominator == null) {
                blockMap = new ValueMap();
            } else {
                ValueMap dominatorMap = this.blockMaps.get(dominator);
                blockMap = dominatorMap.copy();
            }
            this.blockMaps.put(b, blockMap);
            Loop<HIRBlock> hirLoop = b.getLoop();
            LocationSet locationSet = thisLoopKilledLocations = hirLoop == null ? null : ((HIRLoop)hirLoop).getKillLocations();
            if (!b.isLoopHeader()) {
                for (int i = 0; i < b.getPredecessorCount(); ++i) {
                    HIRBlock predecessor = (HIRBlock)b.getPredecessorAt(i);
                    if (b.getDominator() == predecessor) continue;
                    ValueMap predMap = this.blockMaps.get(predecessor);
                    GraalError.guarantee(predMap != null, "This block %s pred block %s", (Object)b.getBeginNode(), (Object)predecessor.getEndNode());
                    blockMap.killAllValuesByOtherMap(predMap);
                }
            } else {
                GVNVisitor.killLoopLocations(thisLoopKilledLocations, blockMap);
            }
            LoopEx loopCandidate = null;
            boolean tryLICM = false;
            if (hirLoop != null && this.considerLICM) {
                block13: {
                    tryLICM = true;
                    for (LoopExitNode lex : ((LoopBeginNode)hirLoop.getHeader().getBeginNode()).loopExits()) {
                        HIRBlock lexBLock = this.cfg.blockFor(lex);
                        if (tryLICM &= b.strictlyDominates(lexBLock)) continue;
                        break block13;
                    }
                    for (HIRBlock loopBlock : hirLoop.getBlocks()) {
                        if (loopBlock.getEndNode() instanceof ControlSinkNode && !(tryLICM &= b.strictlyDominates(loopBlock))) break;
                    }
                }
                if (tryLICM) {
                    loopCandidate = this.ld.loop(hirLoop);
                }
            }
            blockMap.killValuesByPotentialMemoryKill(b.getBeginNode());
            ArrayList<FixedWithNextNode> nodes = new ArrayList<FixedWithNextNode>();
            if (b.getBeginNode() != b.getEndNode()) {
                for (FixedNode cur = (FixedNode)b.getEndNode().predecessor(); cur != b.getBeginNode(); cur = (FixedNode)cur.predecessor()) {
                    nodes.add((FixedWithNextNode)cur);
                }
                for (int i = nodes.size() - 1; i >= 0; --i) {
                    FixedWithNextNode fwn = (FixedWithNextNode)nodes.get(i);
                    if (fwn == null) continue;
                    GVNVisitor.procesNode(fwn, thisLoopKilledLocations, loopCandidate, blockMap, this.licmNodes, this.ld.getCFG());
                }
            }
            blockMap.killValuesByPotentialMemoryKill(b.getEndNode());
            return blockMap;
        }

        public static void killLoopLocations(LocationSet thisLoopKilledLocations, ValueMap blockMap) {
            if (thisLoopKilledLocations != null) {
                for (LocationIdentity loopKilled : thisLoopKilledLocations.getCopyAsList()) {
                    blockMap.killValuesByIdentity(loopKilled);
                }
            }
        }

        private static void procesNode(FixedWithNextNode cur, LocationSet thisLoopKilledLocations, LoopEx loopCandidate, ValueMap blockMap, NodeBitMap licmNodes, ControlFlowGraph cfg) {
            MemoryAccess access;
            boolean canLICM;
            if (cur instanceof LoopExitNode) {
                LoopBeginNode exitedLoop = ((LoopExitNode)cur).loopBegin();
                GVNVisitor.killLoopLocations(((HIRLoop)cfg.blockFor(exitedLoop).getLoop()).getKillLocations(), blockMap);
            }
            if (MemoryKill.isMemoryKill(cur)) {
                blockMap.killValuesByPotentialMemoryKill(cur);
                return;
            }
            if (!DominatorBasedGlobalValueNumberingPhase.canGVN(cur)) {
                return;
            }
            boolean canSubsitute = blockMap.hasSubstitute(cur);
            boolean bl = canLICM = loopCandidate != null;
            if (cur instanceof MemoryAccess && DominatorBasedGlobalValueNumberingPhase.loopKillsLocation(thisLoopKilledLocations, (access = (MemoryAccess)((Object)cur)).getLocationIdentity())) {
                if (canSubsitute) {
                    return;
                }
                canLICM = false;
            }
            if (canLICM) {
                canLICM = DominatorBasedGlobalValueNumberingPhase.nodeCanBeLifted(cur, loopCandidate, licmNodes);
            }
            if (canSubsitute) {
                blockMap.substitute(cur, cfg, licmNodes, canLICM ? loopCandidate : null);
            } else {
                if (canLICM) {
                    DominatorBasedGlobalValueNumberingPhase.tryPerformLICM(loopCandidate, cur, licmNodes);
                }
                blockMap.rememberNodeForGVN(cur);
            }
        }

        @Override
        public void exit(HIRBlock b, ValueMap oldMap) {
        }
    }

    public static final class ValueMap {
        private static final int INITIAL_SIZE = 4;
        private Node[] entries = new Node[4];
        private int length;
        private int deleted;
        private final LocationSet kills = new LocationSet();

        private void grow() {
            this.compress();
            if (this.length == this.entries.length) {
                this.entries = Arrays.copyOf(this.entries, this.entries.length * 2);
            }
        }

        private void compress() {
            if (this.deleted > this.length / 2) {
                Node[] entriesNew = new Node[this.entries.length];
                int newLength = 0;
                for (int i = 0; i < this.length; ++i) {
                    Node entry = this.entries[i];
                    if (entry == null) continue;
                    entriesNew[newLength++] = entry;
                }
                this.entries = entriesNew;
                this.length = newLength;
                this.deleted = 0;
            }
        }

        private Node find(Node n) {
            for (int i = 0; i < this.length; ++i) {
                Node entry = this.entries[i];
                if (entry == null || !ValueMap.valueEquals(entry, n)) continue;
                return entry;
            }
            return null;
        }

        private void add(Node n) {
            this.grow();
            this.entries[this.length++] = n;
        }

        private static boolean valueEquals(Node a, Node b) {
            return a.getNodeClass().equals(b.getNodeClass()) && a.getNodeClass().dataEquals(a, b) && a.getNodeClass().equalInputs(a, b);
        }

        ValueMap copy() {
            ValueMap other = new ValueMap();
            other.entries = Arrays.copyOf(this.entries, this.entries.length);
            other.kills.addAll(this.kills);
            other.length = this.length;
            other.deleted = this.deleted;
            return other;
        }

        public void killAllValuesByOtherMap(ValueMap predMap) {
            for (LocationIdentity otherKills : predMap.kills.getCopyAsList()) {
                this.killValuesByIdentity(otherKills);
            }
        }

        public boolean hasSubstitute(Node n) {
            Node edgeDataEqual = this.find(n);
            assert (edgeDataEqual == null || edgeDataEqual != n) : "Must find different value equal node with different identity for " + n;
            return edgeDataEqual != null;
        }

        public void substitute(Node n, ControlFlowGraph cfg, NodeBitMap licmNodes, LoopEx invariantInLoop) {
            Node edgeDataEqual = this.find(n);
            if (edgeDataEqual != null) {
                assert (edgeDataEqual.graph() != null);
                assert (edgeDataEqual instanceof FixedNode) : "Only process fixed nodes";
                StructuredGraph graph = (StructuredGraph)edgeDataEqual.graph();
                HIRBlock defBlock = cfg.blockFor(edgeDataEqual);
                if (licmNodes.contains(edgeDataEqual)) {
                    assert (defBlock.getLoop() != null);
                    defBlock = (HIRBlock)defBlock.getLoop().getHeader().getDominator();
                }
                if (invariantInLoop != null) {
                    HIRBlock loopDefBlock = (HIRBlock)cfg.blockFor(invariantInLoop.loopBegin()).getLoop().getHeader().getDominator();
                    if (loopDefBlock.strictlyDominates(defBlock)) {
                        if (!DominatorBasedGlobalValueNumberingPhase.tryPerformLICM(invariantInLoop, (FixedNode)edgeDataEqual, licmNodes)) {
                            GraalError.shouldNotReachHere("tryPerformLICM must succeed for " + edgeDataEqual);
                        }
                    } else {
                        GraalError.guarantee(defBlock.dominates(loopDefBlock), "No dominance relation between GVN and LICM locations: %s and %s", (Object)defBlock, (Object)loopDefBlock);
                    }
                }
                HIRBlock useBlock = cfg.blockFor(n);
                Loop<HIRBlock> defLoop = defBlock.getLoop();
                Loop<HIRBlock> useLoop = useBlock.getLoop();
                if (defLoop != null) {
                    if (useLoop != null) {
                        if (!useLoop.isAncestorOrSelf(defLoop)) {
                            earlyGVNAbort.increment(graph.getDebug());
                            return;
                        }
                    } else {
                        earlyGVNAbort.increment(graph.getDebug());
                        return;
                    }
                }
                graph.getDebug().log(5, "Early GVN: replacing %s with %s", (Object)n, (Object)edgeDataEqual);
                graph.getDebug().dump(5, graph, "Before replacing %s with %s", n, edgeDataEqual);
                n.replaceAtUsages(edgeDataEqual);
                GraphUtil.unlinkFixedNode((FixedWithNextNode)n);
                n.safeDelete();
                graph.getDebug().dump(5, graph, "After replacing %s with %s", n, edgeDataEqual);
                earlyGVN.increment(graph.getDebug());
                if (graph.getDebug().isCountEnabled()) {
                    DebugContext.counter(earlyGVN.getName() + "_" + edgeDataEqual.getClass().getSimpleName()).increment(graph.getDebug());
                }
            }
        }

        public void rememberNodeForGVN(Node n) {
            GraalError.guarantee(this.find(n) == null, "Must GVN before adding a new node");
            this.add(n);
        }

        public void killValuesByPotentialMemoryKill(Node n) {
            if (((StructuredGraph)n.graph()).start() == n) {
                return;
            }
            if (MemoryKill.isMemoryKill(n)) {
                if (MemoryKill.isSingleMemoryKill(n)) {
                    SingleMemoryKill singleMemoryKill = MemoryKill.asSingleMemoryKill(n);
                    this.killValuesByIdentity(singleMemoryKill.getKilledLocationIdentity());
                } else if (MemoryKill.isMultiMemoryKill(n)) {
                    MultiMemoryKill multiMemoryKill = MemoryKill.asMultiMemoryKill(n);
                    for (LocationIdentity loc : multiMemoryKill.getKilledLocationIdentities()) {
                        this.killValuesByIdentity(loc);
                    }
                }
            }
        }

        private void killValuesByIdentity(LocationIdentity loc) {
            this.kills.add(loc);
            for (int i = 0; i < this.length; ++i) {
                MemoryAccess mem;
                Node entry = this.entries[i];
                if (entry == null || !(entry instanceof MemoryAccess) || !(mem = (MemoryAccess)((Object)entry)).getLocationIdentity().overlaps(loc)) continue;
                this.entries[i] = null;
                ++this.deleted;
            }
        }
    }
}

