/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases;

import java.util.Optional;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;

public class PlaceholderPhase<C>
extends BasePhase<C> {
    private final Class<? extends BasePhase<? super C>> phaseClass;

    public PlaceholderPhase(Class<? extends BasePhase<? super C>> phaseClass) {
        this.phaseClass = phaseClass;
    }

    public Class<? extends BasePhase<? super C>> getPhaseClass() {
        return this.phaseClass;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return Optional.of(new BasePhase.NotApplicable("This is a " + this.getName() + " for " + this.phaseClass));
    }

    @Override
    public void run(StructuredGraph graph, C context) {
        throw GraalError.shouldNotReachHere(this.getName() + " for " + this.phaseClass + " should have been replaced in the phase plan before execution.");
    }
}

