/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="SideEffectFreeWrite#{p#location/s}")
public class SideEffectFreeWriteNode
extends WriteNode {
    public static final NodeClass<SideEffectFreeWriteNode> TYPE = NodeClass.create(SideEffectFreeWriteNode.class);

    public SideEffectFreeWriteNode(AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType) {
        super(TYPE, address, location, location, value, barrierType, MemoryOrderMode.PLAIN);
    }

    public static WriteNode createWithoutSideEffect(AddressNode address, LocationIdentity location, ValueNode value) {
        return new SideEffectFreeWriteNode(address, location, value, BarrierType.NONE);
    }

    @Override
    public boolean hasSideEffect() {
        return false;
    }
}

