/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.graph.MemoryKillMarker;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNodeInterface;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

public interface MemoryKill
extends ValueNodeInterface,
MemoryKillMarker {
    public static final LocationIdentity NO_LOCATION;
    public static final LocationIdentity[] MULTI_KILL_NO_LOCATION;

    public static boolean isMemoryKill(Node n) {
        if (MemoryKill.isSingleMemoryKill(n)) {
            LocationIdentity killedLocation = MemoryKill.asSingleMemoryKill(n).getKilledLocationIdentity();
            return !killedLocation.equals(NO_LOCATION);
        }
        if (MemoryKill.isMultiMemoryKill(n)) {
            LocationIdentity[] killedLocations = MemoryKill.asMultiMemoryKill(n).getKilledLocationIdentities();
            if (killedLocations.length == 0) {
                return false;
            }
            if (killedLocations.length == 1) {
                return !killedLocations[0].equals(NO_LOCATION);
            }
            return true;
        }
        return false;
    }

    public static boolean isSingleMemoryKill(Node n) {
        return n instanceof SingleMemoryKill;
    }

    public static boolean isMultiMemoryKill(Node n) {
        return n instanceof MultiMemoryKill;
    }

    public static SingleMemoryKill asSingleMemoryKill(Node n) {
        if (!1.$assertionsDisabled && !MemoryKill.isSingleMemoryKill(n)) {
            throw new AssertionError();
        }
        return (SingleMemoryKill)((Object)n);
    }

    public static MultiMemoryKill asMultiMemoryKill(Node n) {
        if (!1.$assertionsDisabled && !MemoryKill.isMultiMemoryKill(n)) {
            throw new AssertionError();
        }
        return (MultiMemoryKill)((Object)n);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NO_LOCATION = new NoLocation();
        MULTI_KILL_NO_LOCATION = new LocationIdentity[0];
    }

    public static final class NoLocation
    extends LocationIdentity {
        private NoLocation() {
        }

        public boolean isImmutable() {
            return true;
        }

        public String toString() {
            return "NO_LOCATION";
        }
    }
}

