/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class FloatableAccessNode
extends FixedAccessNode {
    public static final NodeClass<FloatableAccessNode> TYPE = NodeClass.create(FloatableAccessNode.class);
    protected boolean forceFixed;

    protected FloatableAccessNode(NodeClass<? extends FloatableAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp) {
        super(c, address, location, stamp);
    }

    protected FloatableAccessNode(NodeClass<? extends FloatableAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, BarrierType barrierType) {
        super(c, address, location, stamp, guard, barrierType, false, null);
    }

    protected FloatableAccessNode(NodeClass<? extends FloatableAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, BarrierType barrierType, boolean usedAsNullCheck, FrameState stateBefore) {
        super(c, address, location, stamp, guard, barrierType, usedAsNullCheck, stateBefore);
    }

    public abstract FloatingAccessNode asFloatingNode();

    public void setForceFixed(boolean flag) {
        this.forceFixed = flag;
    }

    public boolean canFloat() {
        return !this.forceFixed && this.getLocationIdentity().isSingle() && (this.getBarrierType() == BarrierType.NONE || this.getBarrierType() == BarrierType.READ);
    }
}

