/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="StoreField#{p#field/s}")
public final class StoreFieldNode
extends AccessFieldNode
implements StateSplit,
Virtualizable,
Canonicalizable,
SingleMemoryKill {
    public static final NodeClass<StoreFieldNode> TYPE = NodeClass.create(StoreFieldNode.class);
    @Node.Input
    ValueNode value;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    public ValueNode value() {
        return this.value;
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value) {
        this(object, field, value, MemoryOrderMode.getMemoryOrder(field));
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, MemoryOrderMode memoryOrder) {
        super(TYPE, StampFactory.forVoid(), object, field, memoryOrder, false);
        this.value = value;
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, FrameState stateAfter) {
        super(TYPE, StampFactory.forVoid(), object, field, MemoryOrderMode.getMemoryOrder(field), false);
        this.value = value;
        this.stateAfter = stateAfter;
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, FrameState stateAfter, MemoryOrderMode memoryOrder) {
        this(object, field, value, stateAfter, memoryOrder, false);
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, FrameState stateAfter, MemoryOrderMode memoryOrder, boolean immutable) {
        super(TYPE, StampFactory.forVoid(), object, field, memoryOrder, immutable);
        this.value = value;
        this.stateAfter = stateAfter;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.ordersMemoryAccesses() ? LocationIdentity.ANY_LOCATION : this.getLocationIdentity();
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualInstanceNode virtual;
        int fieldIndex;
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode && (fieldIndex = (virtual = (VirtualInstanceNode)alias).fieldIndex(this.field())) != -1) {
            tool.setVirtualEntry(virtual, fieldIndex, this.value());
            tool.delete();
        }
    }

    public FrameState getState() {
        return this.stateAfter;
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        if (this.ordersMemoryAccesses()) {
            return NodeCycles.CYCLES_8;
        }
        return super.estimatedNodeCycles();
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!this.field.isStatic() && this.object.isNullConstant()) {
            return new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException);
        }
        return this;
    }
}

