/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(shortName="^")
public final class XorNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Xor>
implements Canonicalizable.BinaryCommutative<ValueNode>,
NarrowableArithmeticNode {
    public static final NodeClass<XorNode> TYPE = NodeClass.create(XorNode.class);

    public XorNode(ValueNode x, ValueNode y) {
        super(TYPE, XorNode.getArithmeticOpTable(x).getXor(), x, y);
        assert (x.stamp(NodeView.DEFAULT).isCompatible(y.stamp(NodeView.DEFAULT)));
    }

    private XorNode(ValueNode x, ValueNode y, Stamp forcedStamp) {
        super(TYPE, forcedStamp, x, y);
    }

    public static ValueNode createForSnippet(ValueNode x, ValueNode y, Stamp forcedStamp) {
        return new XorNode(x, y, forcedStamp);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Xor> op = ArithmeticOpTable.forStamp(x.stamp(view)).getXor();
        ConstantNode tryConstantFold = XorNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return XorNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Xor> getOp(ArithmeticOpTable table) {
        return table.getXor();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        NodeView view = NodeView.from(tool);
        return XorNode.canonical(this, this.getOp(forX, forY), this.stamp(NodeView.DEFAULT), forX, forY, view);
    }

    private static ValueNode canonical(XorNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Xor> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return ConstantNode.forPrimitive(stamp, op.getZero(forX.stamp(view)));
        }
        if (forX.isConstant() && !forY.isConstant()) {
            return new XorNode(forY, forX);
        }
        if (forY.isConstant()) {
            long mask;
            long rawY;
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger() && ((rawY = ((PrimitiveConstant)c).asLong()) & (mask = CodeUtil.mask((int)PrimitiveStamp.getBits(stamp)))) == mask) {
                return new NotNode(forX);
            }
            return XorNode.reassociateMatchedValues(self != null ? self : (XorNode)new XorNode(forX, forY).maybeCommuteInputs(), ValueNode.isConstantPredicate(), forX, forY, view);
        }
        if (forX instanceof NotNode && forY instanceof NotNode) {
            return XorNode.create(((NotNode)forX).getValue(), ((NotNode)forY).getValue(), view);
        }
        if (forY instanceof NotNode && ((NotNode)forY).getValue() == forX) {
            return ConstantNode.forIntegerStamp(forX.stamp(NodeView.DEFAULT), -1L);
        }
        return self != null ? self : new XorNode(forX, forY).maybeCommuteInputs();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitXor(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

