/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;

@NodeInfo(size=NodeSize.SIZE_1)
public abstract class UnaryNode
extends FloatingNode
implements Canonicalizable.Unary<ValueNode> {
    public static final NodeClass<UnaryNode> TYPE = NodeClass.create(UnaryNode.class);
    @Node.Input
    protected ValueNode value;

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public void setValue(ValueNode value) {
        this.updateUsages(this.value, value);
        this.value = value;
    }

    protected UnaryNode(NodeClass<? extends UnaryNode> c, Stamp stamp, ValueNode value) {
        super((NodeClass<? extends FloatingNode>)c, stamp);
        this.value = value;
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.foldStamp(this.value.stamp(NodeView.DEFAULT)));
    }

    public Stamp foldStamp(Stamp newStamp) {
        return this.stamp(NodeView.DEFAULT);
    }
}

