/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ShiftNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName=">>")
public final class RightShiftNode
extends ShiftNode<ArithmeticOpTable.ShiftOp.Shr> {
    public static final NodeClass<RightShiftNode> TYPE = NodeClass.create(RightShiftNode.class);

    public RightShiftNode(ValueNode x, ValueNode y) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getShr(), x, y);
    }

    public static ValueNode create(ValueNode x, int y, NodeView view) {
        if (y == 0) {
            return x;
        }
        return RightShiftNode.create(x, ConstantNode.forInt(y), view);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr> op = ArithmeticOpTable.forStamp(x.stamp(view)).getShr();
        ValueNode value = ShiftNode.canonical(op, stamp = op.foldStamp(x.stamp(view), (IntegerStamp)y.stamp(view)), x, y, view);
        if (value != null) {
            return value;
        }
        return RightShiftNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr> getOp(ArithmeticOpTable table) {
        return table.getShr();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return RightShiftNode.canonical(this, (ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr>)this.getArithmeticOp(), this.stamp(view), forX, forY, view);
    }

    private static ValueNode canonical(RightShiftNode rightShiftNode, ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        IntegerStamp xStamp;
        RightShiftNode self = rightShiftNode;
        if (forX.stamp(view) instanceof IntegerStamp && ((IntegerStamp)forX.stamp(view)).isPositive()) {
            return new UnsignedRightShiftNode(forX, forY);
        }
        Stamp xStampGeneric = forX.stamp(view);
        if (xStampGeneric instanceof IntegerStamp && (xStamp = (IntegerStamp)xStampGeneric).lowerBound() >= -1L && xStamp.upperBound() <= 0L) {
            return forX;
        }
        if (forY.isConstant()) {
            ShiftNode other;
            IntegerStamp xStamp2;
            int amount;
            int originalAmout = amount = forY.asJavaConstant().asInt();
            int mask = op.getShiftAmountMask(stamp);
            if ((amount &= mask) == 0) {
                return forX;
            }
            if (xStampGeneric instanceof IntegerStamp && (xStamp2 = (IntegerStamp)xStampGeneric).lowerBound() >> amount == xStamp2.upperBound() >> amount) {
                return ConstantNode.forIntegerKind(stamp.getStackKind(), xStamp2.lowerBound() >> amount);
            }
            if (forX instanceof ShiftNode && (other = (ShiftNode)forX).getY().isConstant()) {
                int otherAmount = other.getY().asJavaConstant().asInt() & mask;
                if (other instanceof RightShiftNode) {
                    int total = amount + otherAmount;
                    if (total != (total & mask)) {
                        assert (other.getX().stamp(view) instanceof IntegerStamp);
                        IntegerStamp istamp = (IntegerStamp)other.getX().stamp(view);
                        if (istamp.isPositive()) {
                            return ConstantNode.forIntegerKind(stamp.getStackKind(), 0L);
                        }
                        if (istamp.isStrictlyNegative()) {
                            return ConstantNode.forIntegerKind(stamp.getStackKind(), -1L);
                        }
                        assert (total >= mask);
                        return new RightShiftNode(other.getX(), ConstantNode.forInt(mask));
                    }
                    return new RightShiftNode(other.getX(), ConstantNode.forInt(total));
                }
            }
            if (originalAmout != amount) {
                return new RightShiftNode(forX, ConstantNode.forInt(amount));
            }
        }
        if (self == null) {
            self = new RightShiftNode(forX, forY);
        }
        return self;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitShr(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (resultBits >= 32 && super.isNarrowable(resultBits)) {
            IntegerStamp inputStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT);
            return CodeUtil.minValue((int)resultBits) <= inputStamp.lowerBound() && inputStamp.upperBound() <= CodeUtil.maxValue((int)resultBits);
        }
        return false;
    }
}

