/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.MinMaxNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;

@NodeInfo(shortName="Min")
public class MinNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.Min> {
    public static final NodeClass<MinNode> TYPE = NodeClass.create(MinNode.class);

    protected MinNode(ValueNode x, ValueNode y) {
        super(TYPE, MinNode.getArithmeticOpTable(x).getMin(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Min> getOp(ArithmeticOpTable table) {
        return table.getMin();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Min> op = ArithmeticOpTable.forStamp(x.stamp(view)).getMin();
        ConstantNode tryConstantFold = MinNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new MinNode(x, y).maybeCommuteInputs();
    }

    @Override
    public ValueNode asConditional(LoweringProvider lowerer) {
        if (!this.stamp(NodeView.DEFAULT).isIntegerStamp()) {
            return null;
        }
        LogicNode condition = IntegerLessThanNode.create(MinNode.maybeExtendForCompare(this.getX(), lowerer, NumUtil.Signedness.SIGNED), MinNode.maybeExtendForCompare(this.getY(), lowerer, NumUtil.Signedness.SIGNED), NodeView.DEFAULT);
        return ConditionalNode.create(condition, this.getX(), this.getY(), NodeView.DEFAULT);
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (!super.isNarrowable(resultBits)) {
            return false;
        }
        return super.isNarrowable(resultBits, NumUtil.Signedness.SIGNED);
    }
}

