/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.ShiftNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="<<")
public final class LeftShiftNode
extends ShiftNode<ArithmeticOpTable.ShiftOp.Shl> {
    public static final NodeClass<LeftShiftNode> TYPE = NodeClass.create(LeftShiftNode.class);

    public LeftShiftNode(ValueNode x, ValueNode y) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getShl(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl> op = ArithmeticOpTable.forStamp(x.stamp(view)).getShl();
        ValueNode value = ShiftNode.canonical(op, stamp = op.foldStamp(x.stamp(view), (IntegerStamp)y.stamp(view)), x, y, view);
        if (value != null) {
            return value;
        }
        return LeftShiftNode.canonical(null, op, stamp, x, y);
    }

    @Override
    protected ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl> getOp(ArithmeticOpTable table) {
        return table.getShl();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return LeftShiftNode.canonical(this, (ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl>)this.getArithmeticOp(), this.stamp(NodeView.DEFAULT), forX, forY);
    }

    public boolean tryReplaceWithMulNode() {
        Constant c;
        if (this.getY().isConstant() && (c = this.getY().asConstant()) instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger()) {
            IntegerStamp xStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT);
            IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
            IntegerStamp selfStamp = (IntegerStamp)this.stamp(NodeView.DEFAULT);
            if (xStamp.getBits() == yStamp.getBits() && xStamp.getBits() == selfStamp.getBits()) {
                long i = ((PrimitiveConstant)c).asLong();
                long multiplier = (long)Math.pow(2.0, i);
                this.replaceAtUsages(this.graph().addOrUnique(new MulNode(this.getX(), ConstantNode.forIntegerStamp(this.getY().stamp(NodeView.DEFAULT), multiplier, this.graph()))));
                return true;
            }
        }
        return false;
    }

    private static ValueNode canonical(LeftShiftNode leftShiftNode, ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl> op, Stamp stamp, ValueNode forX, ValueNode forY) {
        LeftShiftNode self = leftShiftNode;
        if (forY.isConstant()) {
            ShiftNode other;
            int amount;
            int originalAmount = amount = forY.asJavaConstant().asInt();
            int mask = op.getShiftAmountMask(stamp);
            if ((amount &= mask) == 0) {
                return forX;
            }
            if (forX instanceof ShiftNode && (other = (ShiftNode)forX).getY().isConstant()) {
                int otherAmount = other.getY().asJavaConstant().asInt() & mask;
                if (other instanceof LeftShiftNode) {
                    int total = amount + otherAmount;
                    if (total != (total & mask)) {
                        return ConstantNode.forIntegerKind(stamp.getStackKind(), 0L);
                    }
                    return new LeftShiftNode(other.getX(), ConstantNode.forInt(total));
                }
                if ((other instanceof RightShiftNode || other instanceof UnsignedRightShiftNode) && otherAmount == amount) {
                    if (stamp.getStackKind() == JavaKind.Long) {
                        return new AndNode(other.getX(), ConstantNode.forLong(-1L << amount));
                    }
                    assert (stamp.getStackKind() == JavaKind.Int);
                    return new AndNode(other.getX(), ConstantNode.forInt(-1 << amount));
                }
            }
            if (originalAmount != amount) {
                return new LeftShiftNode(forX, ConstantNode.forInt(amount));
            }
        }
        if (self == null) {
            self = new LeftShiftNode(forX, forY);
        }
        return self;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitShl(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

