/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FixedBinaryNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1)
public abstract class IntegerDivRemNode
extends FixedBinaryNode
implements Lowerable,
IterableNodeType,
GuardingNode {
    public static final NodeClass<IntegerDivRemNode> TYPE = NodeClass.create(IntegerDivRemNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    private GuardingNode zeroGuard;
    private final Op op;
    private final Type type;
    private boolean canDeopt;
    protected JavaConstant deoptReasonAndAction;
    protected JavaConstant deoptSpeculation;

    protected IntegerDivRemNode(NodeClass<? extends IntegerDivRemNode> c, Stamp stamp, Op op, Type type, ValueNode dividend, ValueNode divisor, GuardingNode zeroGuard) {
        super(c, stamp, dividend, divisor);
        this.zeroGuard = zeroGuard;
        this.op = op;
        this.type = type;
        this.canDeopt = this.calculateCanDeoptimize();
    }

    public final GuardingNode getZeroGuard() {
        return this.zeroGuard;
    }

    public void setZeroGuard(GuardingNode zeroCheck) {
        this.updateUsagesInterface(this.zeroGuard, zeroCheck);
        this.zeroGuard = zeroCheck;
    }

    public final Op getOp() {
        return this.op;
    }

    public final Type getType() {
        return this.type;
    }

    private boolean calculateCanDeoptimize() {
        IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
        return yStamp.contains(0L) && this.zeroGuard == null || yStamp.contains(-1L);
    }

    public boolean canFloat() {
        return false;
    }

    public void setCanDeopt(boolean canDeopt) {
        this.canDeopt = canDeopt;
    }

    @Override
    public boolean canDeoptimize() {
        this.canDeopt = this.canDeopt && this.calculateCanDeoptimize();
        return this.canDeopt;
    }

    public JavaConstant getDeoptReasonAndAction() {
        return this.deoptReasonAndAction;
    }

    public JavaConstant getDeoptSpeculation() {
        return this.deoptSpeculation;
    }

    public void setImplicitDeoptimization(JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        assert (deoptReasonAndAction != null && deoptSpeculation != null);
        this.deoptReasonAndAction = deoptReasonAndAction;
        this.deoptSpeculation = deoptSpeculation;
    }

    public static enum Op {
        DIV,
        REM;

    }

    public static enum Type {
        SIGNED,
        UNSIGNED;

    }
}

