/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.Bytecodes;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.MaterializedObjectState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(nameTemplate="@{p#code/s}:{p#bci}", cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public final class FrameState
extends VirtualState
implements IterableNodeType {
    public static final NodeClass<FrameState> TYPE = NodeClass.create(FrameState.class);
    public static final ValueNode TWO_SLOT_MARKER = new TwoSlotMarker();
    private final char localsSize;
    private final char stackSize;
    private final char locksSize;
    private final boolean rethrowException;
    private final boolean duringCall;
    @Node.OptionalInput(value=InputType.State)
    FrameState outerFrameState;
    @Node.OptionalInput
    private NodeInputList<ValueNode> values;
    @Node.Input(value=InputType.Association)
    NodeInputList<MonitorIdNode> monitorIds;
    @Node.OptionalInput(value=InputType.State)
    NodeInputList<EscapeObjectState> virtualObjectMappings;
    public final int bci;
    private final Bytecode code;
    private boolean validForDeoptimization;

    private static char ensureChar(int value) {
        char cvalue = (char)value;
        if (cvalue != value) {
            throw new IllegalArgumentException(value + " (0x" + Integer.toHexString(value) + ") is not a char");
        }
        return cvalue;
    }

    private FrameState(FrameState outerFrameState, Bytecode code, int bci, int localsSize, int stackSize, int locksSize, boolean rethrowException, boolean duringCall, boolean validForDeoptimization, List<MonitorIdNode> monitorIds, List<EscapeObjectState> virtualObjectMappings) {
        super((NodeClass<? extends VirtualState>)TYPE);
        int codeSize;
        if (code != null && (codeSize = code.getCodeSize()) != 0 && bci >= codeSize) {
            throw new GraalError("bci %d is out of range for %s %d bytes", bci, code.getMethod().format("%H.%n(%p)"), codeSize);
        }
        assert (stackSize >= 0);
        this.outerFrameState = outerFrameState;
        assert (outerFrameState == null || outerFrameState.bci >= 0);
        this.code = code;
        this.bci = bci;
        this.localsSize = FrameState.ensureChar(localsSize);
        this.locksSize = FrameState.ensureChar(locksSize);
        this.stackSize = FrameState.ensureChar(stackSize);
        if (monitorIds != null && monitorIds.size() > 0) {
            this.monitorIds = new NodeInputList<MonitorIdNode>((Node)this, monitorIds);
        }
        if (virtualObjectMappings != null && virtualObjectMappings.size() > 0) {
            this.virtualObjectMappings = new NodeInputList<EscapeObjectState>((Node)this, virtualObjectMappings);
        }
        this.rethrowException = rethrowException;
        this.duringCall = duringCall;
        this.validForDeoptimization = validForDeoptimization;
        assert (!this.rethrowException || this.stackSize == '\u0001') : "must have exception on top of the stack";
        assert (this.locksSize() == this.monitorIdCount());
    }

    public FrameState(FrameState outerFrameState, Bytecode code, int bci, List<ValueNode> values, int localsSize, int stackSize, int locksSize, boolean rethrowException, boolean duringCall, boolean validForDeoptimization, List<MonitorIdNode> monitorIds, List<EscapeObjectState> virtualObjectMappings, ValueFunction valueFunction) {
        this(outerFrameState, code, bci, localsSize, stackSize, locksSize, rethrowException, duringCall, validForDeoptimization, monitorIds, virtualObjectMappings);
        this.values = new NodeInputList((Node)this, values.size());
        for (int i = 0; i < values.size(); ++i) {
            ValueNode value = values.get(i);
            if (valueFunction != null) {
                value = valueFunction.apply(i, value);
            }
            this.values.initialize(i, value);
        }
    }

    private void verifyAfterExceptionState() {
        if (this.bci == -4) {
            assert (this.outerFrameState == null);
            for (int i = 0; i < this.localsSize; ++i) {
                this.assertTrue(this.localAt(i) == null, "locals should be null in AFTER_EXCEPTION_BCI state", new Object[0]);
            }
        }
    }

    public FrameState(int bci) {
        this(null, null, bci, 0, 0, 0, false, false, true, null, null);
        assert (bci == -2 || bci == -3 || bci == -4 || bci == -5 || bci == -6);
        this.values = new NodeInputList(this);
    }

    public FrameState(int bci, ValueNode returnValueOrExceptionObject) {
        this(null, null, bci, 0, returnValueOrExceptionObject.getStackKind().getSlotCount(), 0, returnValueOrExceptionObject instanceof ExceptionObjectNode, false, true, null, null);
        assert (bci == -3 && !this.rethrowException() || bci == -4 && this.rethrowException());
        Node[] stack = new ValueNode[]{returnValueOrExceptionObject};
        this.values = new NodeInputList((Node)this, stack);
    }

    public FrameState(FrameState outerFrameState, Bytecode code, int bci, ValueNode[] locals, ValueNode[] stack, int stackSize, JavaKind[] pushedSlotKinds, ValueNode[] pushedValues, ValueNode[] locks, List<MonitorIdNode> monitorIds, boolean rethrowException, boolean duringCall) {
        this(outerFrameState, code, bci, locals.length, stackSize + FrameState.computeSize(pushedSlotKinds), locks.length, rethrowException, duringCall, true, monitorIds, null);
        this.createValues(locals, stack, stackSize, pushedSlotKinds, pushedValues, locks);
    }

    public boolean isValidForDeoptimization() {
        return this.validForDeoptimization;
    }

    public void invalidateForDeoptimization() {
        this.validForDeoptimization = false;
    }

    private static int computeSize(JavaKind[] slotKinds) {
        int result = 0;
        if (slotKinds != null) {
            for (JavaKind slotKind : slotKinds) {
                result += slotKind.getSlotCount();
            }
        }
        return result;
    }

    private void createValues(ValueNode[] locals, ValueNode[] stack, int initialStackSize, JavaKind[] pushedSlotKinds, ValueNode[] pushedValues, ValueNode[] locks) {
        ValueNode value;
        int i;
        ValueNode local;
        int lastNonNullLocal;
        assert (this.values == null);
        for (lastNonNullLocal = locals.length - 1; lastNonNullLocal >= 0 && ((local = locals[lastNonNullLocal]) == null || local == TWO_SLOT_MARKER); --lastNonNullLocal) {
        }
        this.values = new NodeInputList((Node)this, locks.length + this.stackSize + lastNonNullLocal + 1);
        int index = 0;
        for (i = 0; i < locks.length; ++i) {
            value = locks[i];
            assert (value != TWO_SLOT_MARKER);
            this.values.initialize(index++, value);
        }
        for (i = 0; i < initialStackSize; ++i) {
            value = stack[i];
            if (value == TWO_SLOT_MARKER) {
                value = null;
            }
            this.values.initialize(index++, value);
        }
        if (pushedValues != null) {
            assert (pushedSlotKinds.length == pushedValues.length);
            for (i = 0; i < pushedValues.length; ++i) {
                this.values.initialize(index++, pushedValues[i]);
                if (!pushedSlotKinds[i].needsTwoSlots()) continue;
                this.values.initialize(index++, null);
            }
        }
        for (i = 0; i <= lastNonNullLocal; ++i) {
            value = locals[i];
            if (value == TWO_SLOT_MARKER) {
                value = null;
            }
            this.values.initialize(index++, value);
        }
    }

    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    public Node getInput(Position p) {
        int valuesIndex = p.getSubIndex();
        if (valuesIndex >= this.values.size() && valuesIndex < this.locksSize + this.stackSize + this.localsSize && "values".equals(p.getName())) {
            return null;
        }
        return p.get(this);
    }

    public NodeInputList<MonitorIdNode> monitorIds() {
        return this.monitorIds;
    }

    public FrameState outerFrameState() {
        return this.outerFrameState;
    }

    public void setOuterFrameState(FrameState x) {
        assert (x == null || !x.isDeleted() && x.bci >= 0) : "cannot set outer frame state of:\n" + FrameState.toString(this) + "\nto:\n" + FrameState.toString(x) + "\nisDeleted=" + x.isDeleted();
        this.updateUsages(this.outerFrameState, x);
        this.outerFrameState = x;
    }

    public static NodeSourcePosition toSourcePosition(FrameState fs) {
        if (fs == null) {
            return null;
        }
        return new NodeSourcePosition(FrameState.toSourcePosition(fs.outerFrameState()), fs.code.getMethod(), fs.bci);
    }

    public boolean rethrowException() {
        return this.rethrowException;
    }

    public boolean duringCall() {
        return this.duringCall;
    }

    public Bytecode getCode() {
        return this.code;
    }

    public ResolvedJavaMethod getMethod() {
        return this.code == null ? null : this.code.getMethod();
    }

    public boolean canProduceBytecodeFrame() {
        return this.code != null && Arrays.equals(this.code.getCode(), this.code.getMethod().getCode());
    }

    public void addVirtualObjectMapping(EscapeObjectState virtualObject) {
        if (this.virtualObjectMappings == null) {
            this.virtualObjectMappings = new NodeInputList(this);
        }
        this.virtualObjectMappings.add((Object)virtualObject);
    }

    public int virtualObjectMappingCount() {
        if (this.virtualObjectMappings == null) {
            return 0;
        }
        return this.virtualObjectMappings.size();
    }

    public EscapeObjectState virtualObjectMappingAt(int i) {
        return (EscapeObjectState)this.virtualObjectMappings.get(i);
    }

    public NodeInputList<EscapeObjectState> virtualObjectMappings() {
        return this.virtualObjectMappings;
    }

    public FrameState duplicate() {
        return this.graph().add(new FrameState(this.outerFrameState(), this.code, this.bci, this.values, this.localsSize, this.stackSize, this.locksSize, this.rethrowException, this.duringCall, this.validForDeoptimization, this.monitorIds, this.virtualObjectMappings, null));
    }

    public FrameState duplicate(ValueFunction valueFunc) {
        return new FrameState(this.outerFrameState(), this.code, this.bci, this.values, this.localsSize, this.stackSize, this.locksSize, this.rethrowException, this.duringCall, this.validForDeoptimization, this.monitorIds, this.virtualObjectMappings, valueFunc);
    }

    @Override
    public FrameState duplicateWithVirtualState() {
        FrameState newOuterFrameState = this.outerFrameState();
        if (newOuterFrameState != null) {
            newOuterFrameState = newOuterFrameState.duplicateWithVirtualState();
        }
        ArrayList<EscapeObjectState> newVirtualMappings = null;
        if (this.virtualObjectMappings != null) {
            newVirtualMappings = new ArrayList<EscapeObjectState>(this.virtualObjectMappings.size());
            for (EscapeObjectState state : this.virtualObjectMappings) {
                newVirtualMappings.add(state.duplicateWithVirtualState());
            }
        }
        return this.graph().add(new FrameState(newOuterFrameState, this.code, this.bci, this.values, this.localsSize, this.stackSize, this.locksSize, this.rethrowException, this.duringCall, this.validForDeoptimization, this.monitorIds, newVirtualMappings, null));
    }

    public FrameState duplicateModifiedDuringCall(int newBci, JavaKind popKind) {
        return this.duplicateModified(this.graph(), newBci, this.rethrowException, true, popKind, null, null, null);
    }

    public FrameState duplicateModifiedBeforeCall(int newBci, JavaKind popKind, JavaKind[] pushedSlotKinds, ValueNode[] pushedValues, List<EscapeObjectState> pushedVirtualObjectMappings) {
        return this.duplicateModified(this.graph(), newBci, this.rethrowException, false, popKind, pushedSlotKinds, pushedValues, pushedVirtualObjectMappings);
    }

    public FrameState duplicateModified(JavaKind popKind, JavaKind pushedSlotKind, ValueNode pushedValue, List<EscapeObjectState> pushedVirtualObjectMappings) {
        assert (pushedValue != null && pushedValue.getStackKind() == popKind);
        return this.duplicateModified(this.graph(), this.bci, this.rethrowException, this.duringCall, popKind, new JavaKind[]{pushedSlotKind}, new ValueNode[]{pushedValue}, pushedVirtualObjectMappings);
    }

    public FrameState duplicateModified(StructuredGraph graph, int newBci, boolean newRethrowException, boolean newDuringCall, JavaKind popKind, JavaKind[] pushedSlotKinds, ValueNode[] pushedValues, List<EscapeObjectState> pushedVirtualObjectMappings) {
        return this.duplicateModified(graph, newBci, newRethrowException, newDuringCall, popKind, pushedSlotKinds, pushedValues, pushedVirtualObjectMappings, true);
    }

    public FrameState duplicateModified(StructuredGraph graph, int newBci, boolean newRethrowException, boolean newDuringCall, JavaKind popKind, JavaKind[] pushedSlotKinds, ValueNode[] pushedValues, List<EscapeObjectState> pushedVirtualObjectMappings, boolean checkStackDepth) {
        int copyStackSize;
        int newStackSize = 0;
        if (pushedValues != null) {
            assert (pushedSlotKinds.length == pushedValues.length);
            for (int i = 0; i < pushedValues.length; ++i) {
                newStackSize += pushedSlotKinds[i].getSlotCount();
            }
        }
        if (newRethrowException && !this.rethrowException && popKind == JavaKind.Void) {
            assert (popKind == JavaKind.Void);
            copyStackSize = 0;
        } else {
            if (popKind != JavaKind.Void) {
                copyStackSize = this.stackAt(this.stackSize() - 1) == null ? this.stackSize - 2 : this.stackSize - '\u0001';
                ValueNode lastSlot = this.stackAt(copyStackSize);
                assert (lastSlot.getStackKind() == popKind.getStackKind());
            } else {
                copyStackSize = this.stackSize;
            }
            newStackSize += copyStackSize;
        }
        int copyLocalsSize = this.values.size() - this.locksSize - this.stackSize;
        int newValuesSize = this.locksSize + newStackSize + copyLocalsSize;
        ArrayList<ValueNode> newValues = new ArrayList<ValueNode>(newValuesSize);
        if (this.locksSize != '\u0000') {
            newValues.addAll(this.values.subList(0, this.locksSize));
        }
        if (copyStackSize > 0) {
            newValues.addAll(this.values.subList(this.locksSize, this.locksSize + copyStackSize));
        }
        List<EscapeObjectState> copiedVirtualObjectMappings = null;
        if (pushedValues != null) {
            for (int i = 0; i < pushedValues.length; ++i) {
                ValueNode pushedValue = pushedValues[i];
                if (pushedValue instanceof VirtualObjectNode) {
                    copiedVirtualObjectMappings = this.ensureHasVirtualObjectMapping((VirtualObjectNode)pushedValue, pushedVirtualObjectMappings, copiedVirtualObjectMappings);
                }
                newValues.add(pushedValue);
                if (!pushedSlotKinds[i].needsTwoSlots()) continue;
                newValues.add(null);
            }
        }
        if (copyLocalsSize > 0) {
            newValues.addAll(this.values.subList(this.locksSize + this.stackSize, this.values.size()));
        }
        assert (newValues.size() == newValuesSize) : newValues.size() + " != " + newValuesSize;
        assert (!checkStackDepth || this.checkStackDepth(this.bci, this.stackSize, this.duringCall, this.rethrowException, newBci, newStackSize, newDuringCall, newRethrowException));
        return graph.add(new FrameState(this.outerFrameState(), this.code, newBci, newValues, this.localsSize, newStackSize, this.locksSize, newRethrowException, newDuringCall, this.validForDeoptimization, this.monitorIds, copiedVirtualObjectMappings != null ? copiedVirtualObjectMappings : this.virtualObjectMappings, null));
    }

    private List<EscapeObjectState> ensureHasVirtualObjectMapping(VirtualObjectNode pushedValue, List<EscapeObjectState> pushedVirtualObjectMappings, List<EscapeObjectState> copiedVirtualObjectMappings) {
        if (this.virtualObjectMappings != null) {
            for (EscapeObjectState existingEscapeObjectState : this.virtualObjectMappings) {
                if (existingEscapeObjectState.object() != pushedValue) continue;
                return copiedVirtualObjectMappings;
            }
        }
        if (pushedVirtualObjectMappings == null) {
            throw GraalError.shouldNotReachHere("Pushing a virtual object, but no virtual object mapping provided: " + pushedValue);
        }
        for (EscapeObjectState pushedEscapeObjectState : pushedVirtualObjectMappings) {
            if (pushedEscapeObjectState.object() != pushedValue) continue;
            GraalError.guarantee(pushedEscapeObjectState instanceof MaterializedObjectState, "A VirtualObjectState could have transitive dependencies");
            List<EscapeObjectState> result = copiedVirtualObjectMappings;
            if (result == null) {
                result = new ArrayList<EscapeObjectState>();
                if (this.virtualObjectMappings != null) {
                    result.addAll(this.virtualObjectMappings);
                }
            }
            result.add(pushedEscapeObjectState);
            MaterializedObjectState materializedObjectState = (MaterializedObjectState)pushedEscapeObjectState;
            if (materializedObjectState.materializedValue() instanceof VirtualObjectNode) {
                VirtualObjectNode virtualMaterializedValue = (VirtualObjectNode)materializedObjectState.materializedValue();
                result = this.ensureHasVirtualObjectMapping(virtualMaterializedValue, pushedVirtualObjectMappings, result);
            }
            return result;
        }
        throw GraalError.shouldNotReachHere("Did not find a virtual object mapping: " + pushedValue);
    }

    private boolean checkStackDepth(int oldBci, int oldStackSize, boolean oldDuringCall, boolean oldRethrowException, int newBci, int newStackSize, boolean newDuringCall, boolean newRethrowException) {
        if (BytecodeFrame.isPlaceholderBci((int)oldBci)) {
            return true;
        }
        byte[] codes = this.code.getCode();
        if (codes == null) {
            return true;
        }
        byte newCode = codes[newBci];
        if (oldBci == newBci) {
            assert (oldStackSize == newStackSize || oldDuringCall != newDuringCall || oldRethrowException != newRethrowException) : "bci is unchanged, stack depth shouldn't change";
        } else {
            byte oldCode = codes[oldBci];
            assert (Bytecodes.lengthOf(newCode) + newBci == oldBci || Bytecodes.lengthOf(oldCode) + oldBci == newBci) : "expecting roll back or forward";
        }
        return true;
    }

    public int localsSize() {
        return this.localsSize;
    }

    public int stackSize() {
        return this.stackSize;
    }

    public int locksSize() {
        return this.locksSize;
    }

    public int nestedLockDepth() {
        int depth = this.locksSize();
        for (FrameState outer = this.outerFrameState(); outer != null; outer = outer.outerFrameState()) {
            depth += outer.locksSize();
        }
        return depth;
    }

    public ValueNode localAt(int i) {
        assert (i >= 0 && i < this.localsSize) : "local variable index out of range: " + i;
        int valueIndex = this.localToValuesIndex(i);
        if (valueIndex < this.values.size()) {
            return (ValueNode)this.values.get(valueIndex);
        }
        return null;
    }

    private int localToValuesIndex(int i) {
        return i + this.locksSize + this.stackSize;
    }

    public ValueNode stackAt(int i) {
        assert (i >= 0 && i < this.stackSize);
        return (ValueNode)this.values.get(this.locksSize + i);
    }

    public ValueNode lockAt(int i) {
        assert (i >= 0 && i < this.locksSize);
        return (ValueNode)this.values.get(i);
    }

    public MonitorIdNode monitorIdAt(int i) {
        assert (this.monitorIds != null && i >= 0 && i < this.locksSize());
        return (MonitorIdNode)this.monitorIds.get(i);
    }

    public int monitorIdCount() {
        if (this.monitorIds == null) {
            return 0;
        }
        return this.monitorIds.size();
    }

    private static String toString(FrameState frameState) {
        StringBuilder sb = new StringBuilder();
        String nl = CodeUtil.NEW_LINE;
        for (FrameState fs = frameState; fs != null; fs = fs.outerFrameState()) {
            int i;
            Bytecode.appendLocation(sb, fs.getCode(), fs.bci);
            if (BytecodeFrame.isPlaceholderBci((int)fs.bci)) {
                sb.append("//").append(BytecodeFrame.getPlaceholderBciName((int)fs.bci));
            }
            sb.append(nl);
            sb.append("locals: [");
            for (i = 0; i < fs.localsSize(); ++i) {
                sb.append(i == 0 ? "" : ", ").append(fs.localAt(i) == null ? "_" : fs.localAt(i).toString(Verbosity.Id));
            }
            sb.append("]").append(nl).append("stack: [");
            for (i = 0; i < fs.stackSize(); ++i) {
                sb.append(i == 0 ? "" : ", ").append(fs.stackAt(i) == null ? "_" : fs.stackAt(i).toString(Verbosity.Id));
            }
            sb.append("]").append(nl).append("locks: [");
            for (i = 0; i < fs.locksSize(); ++i) {
                sb.append(i == 0 ? "" : ", ").append(fs.lockAt(i) == null ? "_" : fs.lockAt(i).toString(Verbosity.Id));
            }
            sb.append(']').append(nl);
        }
        return sb.toString();
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Debugger) {
            return FrameState.toString(this);
        }
        if (verbosity == Verbosity.Name) {
            String res = super.toString(Verbosity.Name) + "@" + this.bci;
            if (BytecodeFrame.isPlaceholderBci((int)this.bci)) {
                res = res + "[" + BytecodeFrame.getPlaceholderBciName((int)this.bci) + "]";
            }
            return res;
        }
        return super.toString(verbosity);
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        StackTraceElement ste;
        Map<Object, Object> properties = super.getDebugProperties(map);
        if (this.code != null && (ste = this.code.asStackTraceElement(this.bci)).getFileName() != null && ste.getLineNumber() >= 0) {
            properties.put("sourceFile", ste.getFileName());
            properties.put("sourceLine", ste.getLineNumber());
        }
        if (BytecodeFrame.isPlaceholderBci((int)this.bci)) {
            properties.put("bci", BytecodeFrame.getPlaceholderBciName((int)this.bci));
        }
        return properties;
    }

    @Override
    public boolean verify() {
        ValueNode lastAllocatedLocal;
        int allocatedLocals;
        if (this.virtualObjectMappingCount() > 0) {
            for (EscapeObjectState state : this.virtualObjectMappings()) {
                this.assertTrue(state != null, "must be non-null", new Object[0]);
            }
        }
        if ((allocatedLocals = this.values.size() - this.locksSize - this.stackSize) > 0 && (lastAllocatedLocal = (ValueNode)this.values.get(this.values.size() - 1)) == null) {
            throw new AssertionError((Object)"last entry in values for a local must not be null");
        }
        this.assertTrue(this.outerFrameState != null || this.graph() == null || this.graph().method() == null || this.code == null || Objects.equals(this.graph().method(), this.code.getMethod()) || this.graph().isSubstitution(), "wrong outerFrameState %s != %s", this.code == null ? "null" : this.code.getMethod(), this.graph().method());
        if (this.monitorIds() != null && this.monitorIds().size() > 0) {
            int depth = this.outerLockDepth();
            for (MonitorIdNode monitor : this.monitorIds()) {
                this.assertTrue(monitor.getLockDepth() == depth++, "wrong monitor depth at frame state %s", this);
            }
        }
        this.assertTrue(this.locksSize() == this.monitorIdCount(), "mismatch in number of locks at frame state", this);
        for (ValueNode value : this.values) {
            this.assertTrue(value == null || !value.isDeleted(), "frame state %s must not contain deleted nodes: %s", this, value);
            this.assertTrue(value == null || value instanceof VirtualObjectNode || value.getStackKind() != JavaKind.Void, "unexpected value %s at frame state %s", value, this);
        }
        this.verifyAfterExceptionState();
        return super.verify();
    }

    private int outerLockDepth() {
        int depth = 0;
        FrameState outer = this.outerFrameState;
        while (outer != null) {
            depth += outer.monitorIdCount();
            outer = outer.outerFrameState;
        }
        return depth;
    }

    @Override
    public void applyToVirtual(VirtualState.VirtualClosure closure) {
        closure.apply(this);
        if (this.virtualObjectMappings != null) {
            for (EscapeObjectState state : this.virtualObjectMappings) {
                state.applyToVirtual(closure);
            }
        }
        if (this.outerFrameState() != null) {
            this.outerFrameState().applyToVirtual(closure);
        }
    }

    @Override
    public void applyToNonVirtual(VirtualState.NodePositionClosure<? super Node> closure) {
        for (Position pos : this.inputPositions()) {
            if (pos.get(this) == null || pos.getInputType() != InputType.Value && pos.getInputType() != InputType.Association) continue;
            closure.apply(this, pos);
        }
        if (this.virtualObjectMappings != null) {
            for (EscapeObjectState state : this.virtualObjectMappings) {
                state.applyToNonVirtual(closure);
            }
        }
        if (this.outerFrameState() != null) {
            this.outerFrameState().applyToNonVirtual(closure);
        }
    }

    @Override
    public boolean isPartOfThisState(VirtualState state) {
        if (state == this) {
            return true;
        }
        if (this.outerFrameState() != null && this.outerFrameState().isPartOfThisState(state)) {
            return true;
        }
        if (this.virtualObjectMappings != null) {
            for (EscapeObjectState objectState : this.virtualObjectMappings) {
                if (!objectState.isPartOfThisState(state)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExceptionHandlingBCI() {
        return this.bci == -4 || this.bci == -1;
    }

    public static interface ValueFunction {
        public ValueNode apply(int var1, ValueNode var2);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    private static final class TwoSlotMarker
    extends ValueNode {
        public static final NodeClass<TwoSlotMarker> TYPE = NodeClass.create(TwoSlotMarker.class);

        protected TwoSlotMarker() {
            super(TYPE, StampFactory.forKind(JavaKind.Illegal));
        }
    }
}

