/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.OpaqueNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class LoopPartialUnrollPhase
extends LoopPhase<LoopPolicies> {
    public LoopPartialUnrollPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies, canonicalizer);
    }

    private void unroll(StructuredGraph graph, CoreProviders context) {
        Graph.NodeEventScope nes;
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        boolean changed = true;
        EconomicMap opaqueUnrolledStrides = null;
        boolean prePostInserted = false;
        while (changed) {
            changed = false;
            nes = graph.trackNodeEvents(listener);
            try {
                LoopsData dataCounted = context.getLoopsDataProvider().getLoopsData(graph);
                dataCounted.detectCountedLoops();
                Graph.Mark mark = graph.getMark();
                for (LoopEx loop : dataCounted.countedLoops()) {
                    if (!LoopTransformations.isUnrollableLoop(loop) || !this.getPolicies().shouldPartiallyUnroll(loop, context)) continue;
                    if (loop.loopBegin().isSimpleLoop()) {
                        LoopTransformations.insertPrePostLoops(loop);
                        prePostInserted = true;
                        changed = true;
                        continue;
                    }
                    if (!prePostInserted) continue;
                    if (opaqueUnrolledStrides == null) {
                        opaqueUnrolledStrides = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                    }
                    LoopTransformations.partialUnroll(loop, (EconomicMap<LoopBeginNode, OpaqueNode>)opaqueUnrolledStrides);
                    changed = true;
                }
                dataCounted.deleteUnusedNodes();
                if (!listener.getNodes().isEmpty()) {
                    this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
                    listener.getNodes().clear();
                }
                assert (!prePostInserted || LoopPartialUnrollPhase.checkCounted(graph, context.getLoopsDataProvider(), mark));
            }
            finally {
                if (nes == null) continue;
                nes.close();
            }
        }
        if (opaqueUnrolledStrides != null) {
            nes = graph.trackNodeEvents(listener);
            try {
                for (OpaqueNode opaque : opaqueUnrolledStrides.getValues()) {
                    opaque.remove();
                }
                if (!listener.getNodes().isEmpty()) {
                    this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
                }
            }
            finally {
                if (nes != null) {
                    nes.close();
                }
            }
        }
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        if (graph.hasLoops()) {
            try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                this.unroll(graph, context);
            }
            if (!listener.getNodes().isEmpty()) {
                this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
            }
        }
    }

    private static boolean checkCounted(StructuredGraph graph, LoopsDataProvider loopsDataProvider, Graph.Mark mark) {
        LoopsData dataCounted = loopsDataProvider.getLoopsData(graph);
        dataCounted.detectCountedLoops();
        for (LoopEx anyLoop : dataCounted.loops()) {
            if (graph.isNew(mark, anyLoop.loopBegin())) assert (anyLoop.isCounted()) : "pre/post transformation loses counted loop " + anyLoop.loopBegin();
        }
        return true;
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

