/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.dfa;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.lir.util.IndexedValueMap;
import org.graalvm.compiler.lir.util.ValueSet;

final class RegStackValueSet
extends ValueSet<RegStackValueSet> {
    private final FrameMap frameMap;
    private final IndexedValueMap registers;
    private final IndexedValueMap stack;
    private Set<Value> extraStack;

    RegStackValueSet(FrameMap frameMap) {
        this.frameMap = frameMap;
        this.registers = new IndexedValueMap();
        this.stack = new IndexedValueMap();
    }

    private RegStackValueSet(FrameMap frameMap, RegStackValueSet s) {
        this.frameMap = frameMap;
        this.registers = new IndexedValueMap(s.registers);
        this.stack = new IndexedValueMap(s.stack);
        if (s.extraStack != null) {
            this.extraStack = new HashSet<Value>(s.extraStack);
        }
    }

    @Override
    public RegStackValueSet copy() {
        return new RegStackValueSet(this.frameMap, this);
    }

    @Override
    public void put(Value v) {
        if (!RegStackValueSet.shouldProcessValue(v)) {
            return;
        }
        if (ValueUtil.isRegister((Value)v)) {
            int index = ValueUtil.asRegister((Value)v).number;
            this.registers.put(index, v);
        } else if (ValueUtil.isStackSlot((Value)v)) {
            int index = this.frameMap.offsetForStackSlot(ValueUtil.asStackSlot((Value)v));
            assert (index >= 0);
            if (index % 4 == 0) {
                this.stack.put(index / 4, v);
            } else {
                if (this.extraStack == null) {
                    this.extraStack = new HashSet<Value>();
                }
                this.extraStack.add(v);
            }
        }
    }

    @Override
    public void putAll(RegStackValueSet v) {
        this.registers.putAll(v.registers);
        this.stack.putAll(v.stack);
        if (v.extraStack != null) {
            if (this.extraStack == null) {
                this.extraStack = new HashSet<Value>();
            }
            this.extraStack.addAll(v.extraStack);
        }
    }

    @Override
    public void remove(Value v) {
        if (!RegStackValueSet.shouldProcessValue(v)) {
            return;
        }
        if (ValueUtil.isRegister((Value)v)) {
            int index = ValueUtil.asRegister((Value)v).number;
            this.registers.put(index, null);
        } else if (ValueUtil.isStackSlot((Value)v)) {
            int index = this.frameMap.offsetForStackSlot(ValueUtil.asStackSlot((Value)v));
            assert (index >= 0);
            if (index % 4 == 0) {
                this.stack.put(index / 4, null);
            } else if (this.extraStack != null) {
                this.extraStack.remove(v);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegStackValueSet) {
            RegStackValueSet other = (RegStackValueSet)obj;
            return this.registers.equals(other.registers) && this.stack.equals(other.stack) && Objects.equals(this.extraStack, other.extraStack);
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private static boolean shouldProcessValue(Value v) {
        return ValueUtil.isRegister((Value)v) || !LIRKind.isValue(v);
    }

    public void addLiveValues(final ReferenceMapBuilder refMap) {
        ValueConsumer addLiveValue = new ValueConsumer(){

            @Override
            public void visitValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                refMap.addLiveValue(value);
            }
        };
        this.registers.visitEach(null, null, null, addLiveValue);
        this.stack.visitEach(null, null, null, addLiveValue);
        if (this.extraStack != null) {
            for (Value v : this.extraStack) {
                refMap.addLiveValue(v);
            }
        }
    }

    public String toString() {
        return "registers: " + this.registers.toString() + "\nstack: " + this.stack.toString();
    }
}

