/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.asm;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.ImplicitLIRFrameState;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionVerifier;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class CompilationResultBuilder {
    public static final List<LIRInstructionVerifier> NO_VERIFIERS = Collections.emptyList();
    public final Assembler<?> asm;
    public final DataBuilder dataBuilder;
    public final CompilationResult compilationResult;
    public final Register uncompressedNullRegister;
    public final TargetDescription target;
    public final CodeGenProviders providers;
    public final CodeCacheProvider codeCache;
    public final ForeignCallsProvider foreignCalls;
    public final FrameMap frameMap;
    protected final LIR lir;
    protected int currentBlockIndex;
    public final FrameContext frameContext;
    private List<ExceptionInfo> exceptionInfoList;
    private List<PendingImplicitException> pendingImplicitExceptionList;
    private final OptionValues options;
    private final DebugContext debug;
    private final EconomicMap<Constant, DataSection.Data> dataCache;
    private EconomicMap<Label, Integer> labelBindLirPositions;
    private EconomicMap<LIRInstruction, Integer> lirPositions;
    private boolean conservativeLabelOffsets = false;
    private boolean needsMHDeoptHandler = false;
    private int lastImplicitExceptionOffset = Integer.MIN_VALUE;
    private final List<LIRInstructionVerifier> lirInstructionVerifiers;

    public final boolean mustReplaceWithUncompressedNullRegister(JavaConstant nullConstant) {
        return !this.uncompressedNullRegister.equals((Object)Register.None) && JavaConstant.NULL_POINTER.equals(nullConstant);
    }

    public CompilationResultBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler<?> asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister, EconomicMap<Constant, DataSection.Data> dataCache, List<LIRInstructionVerifier> lirInstructionVerifiers, LIR lir) {
        this.target = providers.getCodeCache().getTarget();
        this.providers = providers;
        this.codeCache = providers.getCodeCache();
        this.foreignCalls = providers.getForeignCalls();
        this.frameMap = frameMap;
        this.asm = asm;
        this.dataBuilder = dataBuilder;
        this.lir = lir;
        this.compilationResult = compilationResult;
        this.uncompressedNullRegister = uncompressedNullRegister;
        this.frameContext = frameContext;
        this.options = options;
        this.debug = debug;
        assert (frameContext != null);
        this.dataCache = dataCache;
        this.lirInstructionVerifiers = Objects.requireNonNull(lirInstructionVerifiers);
    }

    public void setTotalFrameSize(int frameSize) {
        this.compilationResult.setTotalFrameSize(frameSize);
    }

    public void setMaxInterpreterFrameSize(int maxInterpreterFrameSize) {
        this.compilationResult.setMaxInterpreterFrameSize(maxInterpreterFrameSize);
    }

    public void setMinDataSectionItemAlignment(int alignment) {
        this.compilationResult.setMinDataSectionItemAlignment(alignment);
    }

    public CompilationResult.CodeMark recordMark(int codePos, CompilationResult.MarkId markId) {
        return this.compilationResult.recordMark(codePos, markId);
    }

    public CompilationResult.CodeMark recordMark(CompilationResult.MarkId markId) {
        return this.recordMark(this.asm.position(), markId);
    }

    public void blockComment(String s) {
        this.compilationResult.addAnnotation(new CompilationResult.CodeComment(this.asm.position(), s));
    }

    public void finish() {
        int position = this.asm.position();
        this.compilationResult.setTargetCode(this.asm.close(false), position);
        if (this.exceptionInfoList != null) {
            for (ExceptionInfo ei : this.exceptionInfoList) {
                int codeOffset = ei.codeOffset;
                this.compilationResult.recordExceptionHandler(codeOffset, ei.exceptionEdge.label().position());
            }
        }
        this.closeCompilationResult();
    }

    protected void closeCompilationResult() {
        this.compilationResult.close(this.options);
    }

    public void recordExceptionHandlers(int pcOffset, LIRFrameState info) {
        if (info != null && info.exceptionEdge != null) {
            if (this.exceptionInfoList == null) {
                this.exceptionInfoList = new ArrayList<ExceptionInfo>(4);
            }
            this.exceptionInfoList.add(new ExceptionInfo(pcOffset, info.exceptionEdge));
        }
    }

    public void recordImplicitException(int pcOffset, LIRFrameState info) {
        this.lastImplicitExceptionOffset = pcOffset;
        if (GraalServices.supportsArbitraryImplicitException() && info instanceof ImplicitLIRFrameState) {
            if (this.pendingImplicitExceptionList == null) {
                this.pendingImplicitExceptionList = new ArrayList<PendingImplicitException>(4);
            }
            this.pendingImplicitExceptionList.add(new PendingImplicitException(pcOffset, (ImplicitLIRFrameState)info));
        } else {
            this.recordImplicitException(pcOffset, pcOffset, info);
        }
    }

    public void recordImplicitException(int pcOffset, int dispatchOffset, LIRFrameState info) {
        this.compilationResult.recordImplicitException(pcOffset, dispatchOffset, info.debugInfo());
        assert (info.exceptionEdge == null);
    }

    public int getLastImplicitExceptionOffset() {
        return this.lastImplicitExceptionOffset;
    }

    private void recordIfCallInvalidForDeoptimization(LIRFrameState info, Call call) {
        if (info != null && !info.validForDeoptimization && info.hasDebugInfo()) {
            DebugInfo debugInfo = info.debugInfo();
            assert (debugInfo != null);
            if (debugInfo.hasFrame()) {
                this.compilationResult.recordCallInvalidForDeoptimization(call);
            }
        }
    }

    public Call recordDirectCall(int posBefore, int posAfter, InvokeTarget callTarget, LIRFrameState info) {
        DebugInfo debugInfo = info != null ? info.debugInfo() : null;
        Call call = this.compilationResult.recordCall(posBefore, posAfter - posBefore, callTarget, debugInfo, true);
        this.recordIfCallInvalidForDeoptimization(info, call);
        return call;
    }

    public Call recordIndirectCall(int posBefore, int posAfter, InvokeTarget callTarget, LIRFrameState info) {
        DebugInfo debugInfo = info != null ? info.debugInfo() : null;
        Call infopoint = this.compilationResult.recordCall(posBefore, posAfter - posBefore, callTarget, debugInfo, false);
        this.recordIfCallInvalidForDeoptimization(info, infopoint);
        return infopoint;
    }

    public void recordInfopoint(int pos, LIRFrameState info, InfopointReason reason) {
        DebugInfo debugInfo = info.debugInfo();
        this.recordInfopoint(pos, debugInfo, reason);
    }

    public void recordInfopoint(int pos, DebugInfo debugInfo, InfopointReason reason) {
        this.compilationResult.recordInfopoint(pos, debugInfo, reason);
    }

    public void recordSourceMapping(int pcOffset, int endPcOffset, NodeSourcePosition sourcePosition) {
        this.compilationResult.recordSourceMapping(pcOffset, endPcOffset, sourcePosition);
    }

    public void recordInlineDataInCode(Constant data) {
        assert (data != null);
        int pos = this.asm.position();
        this.debug.log("Inline data in code: pos = %d, data = %s", pos, (Object)data);
        if (data instanceof VMConstant) {
            this.compilationResult.recordDataPatch(pos, (Reference)new ConstantReference((VMConstant)data));
        }
    }

    public void recordInlineDataInCodeWithNote(Constant data, Object note) {
        assert (data != null);
        int pos = this.asm.position();
        this.debug.log("Inline data in code: pos = %d, data = %s, note = %s", (Object)pos, (Object)data, note);
        if (data instanceof VMConstant) {
            this.compilationResult.recordDataPatchWithNote(pos, (Reference)new ConstantReference((VMConstant)data), note);
        }
    }

    public AbstractAddress recordDataSectionReference(DataSection.Data data) {
        assert (data != null);
        DataSectionReference reference = this.compilationResult.getDataSection().insertData(data);
        int instructionStart = this.asm.position();
        this.compilationResult.recordDataPatch(instructionStart, (Reference)reference);
        return this.asm.getPlaceholder(instructionStart);
    }

    public AbstractAddress recordDataReferenceInCode(DataPointerConstant constant) {
        return this.recordDataReferenceInCode((Constant)constant, constant.getAlignment());
    }

    public AbstractAddress recordDataReferenceInCode(Constant constant, int alignment) {
        assert (constant != null);
        this.debug.log("Constant reference in code: pos = %d, data = %s", this.asm.position(), (Object)constant);
        DataSection.Data data = this.createDataItem(constant);
        this.dataBuilder.updateAlignment(data, alignment);
        return this.recordDataSectionReference(data);
    }

    public AbstractAddress recordDataReferenceInCode(DataSection.Data data, int alignment) {
        assert (data != null);
        this.dataBuilder.updateAlignment(data, alignment);
        return this.recordDataSectionReference(data);
    }

    public DataSection.Data createDataItem(Constant constant) {
        DataSection.Data previousData;
        DataSection.Data data = (DataSection.Data)this.dataCache.get((Object)constant);
        if (data == null && (previousData = (DataSection.Data)this.dataCache.putIfAbsent((Object)constant, (Object)(data = this.dataBuilder.createDataItem(constant)))) != null) {
            data = previousData;
        }
        return data;
    }

    public AbstractAddress recordDataReferenceInCode(byte[] data, int alignment) {
        assert (data != null);
        if (this.debug.isLogEnabled()) {
            this.debug.log("Data reference in code: pos = %d, data = %s", this.asm.position(), (Object)Arrays.toString(data));
        }
        ArrayDataPointerConstant arrayConstant = new ArrayDataPointerConstant(data, alignment);
        return this.recordDataSectionReference(this.dataBuilder.createSerializableData(arrayConstant, alignment));
    }

    public AbstractAddress asFloatConstRef(JavaConstant value) {
        return this.asFloatConstRef(value, 4);
    }

    public AbstractAddress asFloatConstRef(JavaConstant value, int alignment) {
        assert (value.getJavaKind() == JavaKind.Float);
        return this.recordDataReferenceInCode((Constant)value, alignment);
    }

    public AbstractAddress asDoubleConstRef(JavaConstant value) {
        return this.asDoubleConstRef(value, 8);
    }

    public AbstractAddress asDoubleConstRef(JavaConstant value, int alignment) {
        assert (value.getJavaKind() == JavaKind.Double);
        return this.recordDataReferenceInCode((Constant)value, alignment);
    }

    public AbstractAddress asLongConstRef(JavaConstant value) {
        assert (value.getJavaKind() == JavaKind.Long);
        return this.recordDataReferenceInCode((Constant)value, 8);
    }

    public AbstractAddress asAddress(Value value) {
        assert (ValueUtil.isStackSlot((Value)value));
        StackSlot slot = ValueUtil.asStackSlot((Value)value);
        int size = slot.getPlatformKind().getSizeInBytes() * 8;
        return this.asm.makeAddress(size, this.frameMap.getRegisterConfig().getFrameRegister(), this.frameMap.offsetForStackSlot(slot));
    }

    public boolean isSuccessorEdge(LabelRef edge) {
        assert (this.lir != null);
        int[] order = this.lir.codeEmittingOrder();
        assert (order[this.currentBlockIndex] == edge.getSourceBlock().getId());
        BasicBlock<?> nextBlock = LIR.getNextBlock(this.lir.getControlFlowGraph(), order, this.currentBlockIndex);
        return nextBlock == edge.getTargetBlock();
    }

    public void emitLIR() {
        assert (this.currentBlockIndex == 0);
        assert (this.lastImplicitExceptionOffset == Integer.MIN_VALUE);
        this.currentBlockIndex = 0;
        this.lastImplicitExceptionOffset = Integer.MIN_VALUE;
        this.frameContext.enter(this);
        BasicBlockInfoLogger logger = new BasicBlockInfoLogger();
        BasicBlock<?> previousBlock = null;
        for (int blockId : this.lir.codeEmittingOrder()) {
            BasicBlock<?> b = this.lir.getBlockById(blockId);
            assert (b == null && this.lir.codeEmittingOrder()[this.currentBlockIndex] == Integer.MAX_VALUE || this.lir.codeEmittingOrder()[this.currentBlockIndex] == blockId);
            if (b != null) {
                if (b.isAligned() && previousBlock != null) {
                    boolean hasSuccessorB = false;
                    for (int i = 0; i < previousBlock.getSuccessorCount(); ++i) {
                        Object succ = previousBlock.getSuccessorAt(i);
                        if (succ != b) continue;
                        hasSuccessorB = true;
                        break;
                    }
                    if (!hasSuccessorB) {
                        ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(b);
                        assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
                        StandardOp.LabelOp label = (StandardOp.LabelOp)instructions.get(0);
                        label.setAlignment(GraalOptions.IsolatedLoopHeaderAlignment.getValue(this.options));
                    }
                }
                int basicBlockStartingPC = this.asm.position();
                this.emitBlock(b);
                int basicBlockEndingPC = this.asm.position();
                logger.log(b, basicBlockStartingPC, basicBlockEndingPC);
                previousBlock = b;
            }
            ++this.currentBlockIndex;
        }
        ArrayList<LIRInstruction.LIRInstructionSlowPath> slowPaths = this.lir.getSlowPaths();
        if (slowPaths != null) {
            for (LIRInstruction.LIRInstructionSlowPath slowPath : slowPaths) {
                try {
                    this.emitSlowPath(slowPath);
                }
                catch (GraalError e) {
                    if (slowPath.forOp() != null) {
                        throw e.addContext("lir instruction", "slow path for " + slowPath.forOp() + " " + slowPath);
                    }
                    throw e.addContext("lir instruction", "slow path " + slowPath);
                }
            }
        }
        logger.close();
        this.currentBlockIndex = 0;
        this.lastImplicitExceptionOffset = Integer.MIN_VALUE;
    }

    public LIR getLIR() {
        return this.lir;
    }

    private void emitBlock(BasicBlock<?> block) {
        boolean emitComment;
        if (block == null) {
            return;
        }
        boolean bl = emitComment = this.debug.isDumpEnabled(1) || Options.PrintLIRWithAssembly.getValue(this.getOptions()) != false;
        if (emitComment) {
            this.blockComment(String.format("block B%d %s", block.getId(), block.getLoop()));
        }
        for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
            if (emitComment) {
                this.blockComment(String.format("%d %s", op.id(), op));
            }
            try {
                this.emitOp(op);
            }
            catch (GraalError e) {
                throw e.addContext("lir instruction", block + "@" + op.id() + " " + op.getClass().getName() + " " + op);
            }
        }
    }

    private void emitSlowPath(LIRInstruction.LIRInstructionSlowPath op) {
        try {
            op.emitSlowPathCode();
            this.asm.halt();
        }
        catch (BailoutException e) {
            throw e;
        }
        catch (AssertionError t) {
            throw new GraalError((Throwable)((Object)t));
        }
        catch (RuntimeException t) {
            throw new GraalError(t);
        }
    }

    private void emitOp(LIRInstruction op) {
        try {
            int start = this.asm.position();
            op.emitCode(this);
            if (op.getPosition() != null) {
                this.recordSourceMapping(start, this.asm.position(), op.getPosition());
            }
            if (!this.lirInstructionVerifiers.isEmpty() && start < this.asm.position()) {
                int end = this.asm.position();
                for (CompilationResult.CodeAnnotation codeAnnotation : this.compilationResult.getCodeAnnotations()) {
                    int jumpTableStart;
                    if (!(codeAnnotation instanceof CompilationResult.JumpTable) || (jumpTableStart = codeAnnotation.getPosition()) < start || jumpTableStart >= end) continue;
                    end = jumpTableStart;
                }
                byte[] emittedCode = this.asm.copy(start, end);
                this.lirInstructionVerifiers.forEach(v -> v.verify(op, emittedCode));
            }
        }
        catch (BailoutException e) {
            throw e;
        }
        catch (AssertionError t) {
            throw new GraalError((Throwable)((Object)t));
        }
        catch (RuntimeException t) {
            throw new GraalError(t);
        }
    }

    public void resetForEmittingCode() {
        this.asm.reset();
        this.compilationResult.resetForEmittingCode();
        if (this.exceptionInfoList != null) {
            this.exceptionInfoList.clear();
        }
        if (this.pendingImplicitExceptionList != null) {
            this.pendingImplicitExceptionList.clear();
        }
        if (this.dataCache != null) {
            this.dataCache.clear();
        }
        this.currentBlockIndex = 0;
        this.lastImplicitExceptionOffset = Integer.MIN_VALUE;
        this.lir.resetLabels();
    }

    public OptionValues getOptions() {
        return this.options;
    }

    public void buildLabelOffsets() {
        this.labelBindLirPositions = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        this.lirPositions = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        int instructionPosition = 0;
        for (int blockId : this.lir.getBlocks()) {
            if (LIR.isBlockDeleted(blockId)) continue;
            BasicBlock<?> block = this.lir.getBlockById(blockId);
            for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
                Label label;
                if (op instanceof StandardOp.LabelHoldingOp && (label = ((StandardOp.LabelHoldingOp)((Object)op)).getLabel()) != null) {
                    this.labelBindLirPositions.put((Object)label, (Object)instructionPosition);
                }
                this.lirPositions.put((Object)op, (Object)instructionPosition);
                ++instructionPosition;
            }
        }
    }

    public boolean labelWithinLIRRange(LIRInstruction instruction, Label label, int maxLIRDistance) {
        if (this.conservativeLabelOffsets) {
            return false;
        }
        Integer labelPosition = (Integer)this.labelBindLirPositions.get((Object)label);
        Integer instructionPosition = (Integer)this.lirPositions.get((Object)instruction);
        if (labelPosition != null && instructionPosition != null) {
            return Math.abs(labelPosition - instructionPosition) < maxLIRDistance;
        }
        return false;
    }

    public void setConservativeLabelRanges() {
        this.conservativeLabelOffsets = true;
    }

    public final boolean needsClearUpperVectorRegisters() {
        for (int blockId : this.lir.getBlocks()) {
            if (LIR.isBlockDeleted(blockId)) continue;
            BasicBlock<?> block = this.lir.getBlockById(blockId);
            for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
                if (!op.needsClearUpperVectorRegisters()) continue;
                return true;
            }
        }
        return false;
    }

    public void setNeedsMHDeoptHandler() {
        this.needsMHDeoptHandler = true;
    }

    public boolean needsMHDeoptHandler() {
        return this.needsMHDeoptHandler;
    }

    public List<PendingImplicitException> getPendingImplicitExceptionList() {
        return this.pendingImplicitExceptionList;
    }

    private static class ExceptionInfo {
        public final int codeOffset;
        public final LabelRef exceptionEdge;

        ExceptionInfo(int pcOffset, LabelRef exceptionEdge) {
            this.codeOffset = pcOffset;
            this.exceptionEdge = exceptionEdge;
        }
    }

    public static class PendingImplicitException {
        public final int codeOffset;
        public final ImplicitLIRFrameState state;

        PendingImplicitException(int pcOffset, ImplicitLIRFrameState state) {
            this.codeOffset = pcOffset;
            this.state = state;
        }
    }

    private class BasicBlockInfoLogger {
        final boolean isEnable;
        final Formatter formatter;

        BasicBlockInfoLogger() {
            this.isEnable = DebugOptions.PrintBBInfo.getValue(CompilationResultBuilder.this.options) != false && CompilationResultBuilder.this.debug.methodFilterMatchesCurrentMethod();
            this.formatter = this.isEnable ? new Formatter() : null;
        }

        void log(BasicBlock<?> b, int startPC, int endPC) {
            if (this.isEnable) {
                this.formatter.format("%d, %d, %d, %f, [", b.getId(), startPC, endPC, b.getRelativeFrequency());
                for (int i = 0; i < b.getSuccessorCount(); ++i) {
                    if (i < b.getSuccessorCount() - 1) {
                        this.formatter.format("(%d, %f),", ((BasicBlock)b.getSuccessorAt(i)).getId(), b.getSuccessorProbabilityAt(i));
                        continue;
                    }
                    this.formatter.format("(%d, %f)", ((BasicBlock)b.getSuccessorAt(i)).getId(), b.getSuccessorProbabilityAt(i));
                }
                this.formatter.format("]\n", new Object[0]);
            }
        }

        void close() {
            if (this.isEnable) {
                String path = CompilationResultBuilder.this.debug.getDumpPath(".blocks", false);
                try {
                    Files.writeString(Paths.get(path, new String[0]), (CharSequence)this.formatter.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw CompilationResultBuilder.this.debug.handle(e);
                }
            }
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> PrintLIRWithAssembly = new OptionKey<Boolean>(false);
    }
}

