/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.asm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.graalvm.compiler.core.common.type.DataPointerConstant;

public class ArrayDataPointerConstant
extends DataPointerConstant {
    private final byte[] data;

    public ArrayDataPointerConstant(byte[] array, int alignment) {
        super(alignment);
        this.data = (byte[])array.clone();
    }

    public ArrayDataPointerConstant(short[] array, int alignment) {
        super(alignment);
        ByteBuffer byteBuffer = ByteBuffer.allocate(array.length * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asShortBuffer().put(array);
        this.data = byteBuffer.array();
    }

    public ArrayDataPointerConstant(int[] array, int alignment) {
        super(alignment);
        ByteBuffer byteBuffer = ByteBuffer.allocate(array.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asIntBuffer().put(array);
        this.data = byteBuffer.array();
    }

    public ArrayDataPointerConstant(float[] array, int alignment) {
        super(alignment);
        ByteBuffer byteBuffer = ByteBuffer.allocate(array.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asFloatBuffer().put(array);
        this.data = byteBuffer.array();
    }

    @Override
    public boolean isDefaultForKind() {
        return false;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.put(this.data);
    }

    public int getSerializedSize() {
        return this.data.length;
    }

    public String toValueString() {
        return "ArrayDataPointerConstant" + Arrays.toString(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayDataPointerConstant that = (ArrayDataPointerConstant)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return "ArrayDataPointerConstant{data=" + Arrays.toString(this.data) + ", size=" + this.getSerializedSize() + ", alignment=" + this.getAlignment() + "}";
    }
}

