/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64UnaryConsumer {

    public static class MemoryOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<MemoryOp> TYPE = LIRInstructionClass.create(MemoryOp.class);
        @Opcode
        private final AMD64Assembler.AMD64MOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue value;

        public MemoryOp(AMD64Assembler.AMD64MOp opcode, AMD64BaseAssembler.OperandSize size, AMD64AddressValue value) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.opcode.emit((AMD64Assembler)masm, this.size, this.value.toAddress());
        }

        public AMD64Assembler.AMD64MOp getOpcode() {
            return this.opcode;
        }
    }
}

