/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.StubPorts;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPorts(value={@StubPort(path="src/hotspot/cpu/x86/x86_64.ad", lineStart=12800, lineEnd=12824, commit="afda8fbf0bcea18cbe741e9c693789ebe0c6c4c5", sha1="997a3fd0c34599035d44866b15f1efc7eb28945e"), @StubPort(path="src/hotspot/cpu/x86/x86_64.ad", lineStart=12852, lineEnd=12876, commit="afda8fbf0bcea18cbe741e9c693789ebe0c6c4c5", sha1="9c6287fe33d5c9be006582942ba131188a924ee3")})
public class AMD64NormalizedUnsignedCompareOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64NormalizedUnsignedCompareOp> TYPE = LIRInstructionClass.create(AMD64NormalizedUnsignedCompareOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue x;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue y;

    public AMD64NormalizedUnsignedCompareOp(AllocatableValue result, AllocatableValue x, AllocatableValue y) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.result = result;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label done = new Label();
        if (this.x.getPlatformKind() == AMD64Kind.DWORD) {
            masm.cmpl(ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        } else {
            GraalError.guarantee(this.x.getPlatformKind() == AMD64Kind.QWORD, "unsupported value kind %s", (Object)this.x.getPlatformKind());
            masm.cmpq(ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        }
        masm.movl(ValueUtil.asRegister((Value)this.result), -1);
        masm.jccb(AMD64Assembler.ConditionFlag.Below, done);
        masm.setl(AMD64Assembler.ConditionFlag.NotEqual, ValueUtil.asRegister((Value)this.result));
        masm.bind(done);
    }
}

