/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class AMD64MathSignumOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64MathSignumOp> TYPE = LIRInstructionClass.create(AMD64MathSignumOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected Value result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value scratch;
    private static ArrayDataPointerConstant floatOne = AMD64HotSpotHelper.pointerConstant(8, new int[]{1065353216, 0});
    private static ArrayDataPointerConstant floatSignMask = AMD64HotSpotHelper.pointerConstant(16, new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE});
    private static ArrayDataPointerConstant doubleOne = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 0x3FF00000});
    private static ArrayDataPointerConstant doubleSignMask = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, Integer.MIN_VALUE});

    public AMD64MathSignumOp(LIRGeneratorTool tool, Value result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
        this.scratch = tool.newVariable(LIRKind.value(input.getPlatformKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        PlatformKind kind = this.input.getPlatformKind();
        Register scratchReg = ValueUtil.asRegister((Value)this.scratch);
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        Label done = new Label();
        AMD64Move.move(crb, masm, this.result, this.input);
        if (kind == AMD64Kind.SINGLE) {
            masm.xorps(scratchReg, scratchReg);
            masm.ucomiss(resultReg, scratchReg);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, done);
            masm.jcc(AMD64Assembler.ConditionFlag.Parity, done);
            masm.movflt(resultReg, AMD64HotSpotHelper.recordExternalAddress(crb, floatOne));
            masm.jcc(AMD64Assembler.ConditionFlag.Above, done);
            masm.xorps(resultReg, AMD64HotSpotHelper.recordExternalAddress(crb, floatSignMask));
            masm.bind(done);
        } else if (kind == AMD64Kind.DOUBLE) {
            masm.xorpd(scratchReg, scratchReg);
            masm.ucomisd(resultReg, scratchReg);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, done);
            masm.jcc(AMD64Assembler.ConditionFlag.Parity, done);
            masm.movdbl(resultReg, AMD64HotSpotHelper.recordExternalAddress(crb, doubleOne));
            masm.jcc(AMD64Assembler.ConditionFlag.Above, done);
            masm.xorpd(resultReg, AMD64HotSpotHelper.recordExternalAddress(crb, doubleSignMask));
            masm.bind(done);
        } else {
            throw GraalError.shouldNotReachHere("unsupported kind for Math.signum");
        }
    }
}

