/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64MathIntrinsicUnaryOp;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPort(path="src/hotspot/cpu/x86/stubGenerator_x86_64_log.cpp", lineStart=32, lineEnd=363, commit="090cdfc7a2e280c620a0926512fb67f0ce7f3c21", sha1="fd2dcad178f60306e830e0f7aeaeee376d47ea81")
public final class AMD64MathLogOp
extends AMD64MathIntrinsicUnaryOp {
    public static final LIRInstructionClass<AMD64MathLogOp> TYPE = LIRInstructionClass.create(AMD64MathLogOp.class);
    private static ArrayDataPointerConstant lTbl = AMD64HotSpotHelper.pointerConstant(16, new int[]{-17156096, 1072049730, -1815648464, 1026487127, -1440475136, 1072033410, 215631550, 1025638968, 1547061248, 1072017216, -1408185861, 1026423395, 649825280, 1072001146, -13433891, 1024038923, 646346752, 1071985198, 1562735921, 1023790276, -2091233280, 1071969370, 1838397691, -1121031087, 1872169984, 1071953661, -313764836, 1022325013, 669557760, 1071938069, -112369494, -1121793174, -218553344, 1071922591, 1209029111, -1124231089, 556125184, 1071907228, 821086028, -1121530247, 204914688, 1071891976, 2097025986, -1123895498, 387545088, 1071876834, -1152030300, -1121875078, -1382183936, 1071861800, -1792547156, 1024505919, 1144260608, 1071846874, -979309156, -1121497453, 1471209472, 1071832053, 129621009, -1122523419, 1829683200, 1071817336, -409499603, 1025535275, 288676864, 1071802722, 86139472, -1123327503, -658588672, 1071788208, 1850238587, 1024654342, 1606817792, 1071773795, -906067501, -1121291710, 1236164608, 1071759480, -311368089, 1020046558, 1089616896, 1071745262, -122993072, 1024773198, -151873536, 1071731139, -1567379895, -1121002089, 600267776, 1071717112, -1147282254, -1121614265, -2045654016, 1071703177, 125835074, 1025255832, -489663488, 1071689334, -2004976089, 1025460331, 87278592, 1071675583, 1106114045, 1025933602, -1099561984, 1071661920, -409650720, -1123761057, -441317376, 1071648346, -1317897444, -1123730525, -1350940672, 1071625048, 1008093493, 1023444474, -301787136, 1071598247, 1862355595, 1024642533, 1454641152, 1071571617, 1514603089, 1026500596, -1008881664, 1071545154, 1400028424, -1121688240, 438773760, 1071518858, 120727864, -1122818382, 1212979200, 1071492725, 1625055594, -1122065363, 1189017600, 1071466754, -374904920, 1025727407, 403064832, 1071440943, 1053271728, -1123575869, -951756800, 1071415289, -1051571794, -1121339683, 1765777408, 1071389792, 2145968512, 1026354304, 461430784, 1071364449, -200645011, 1026021467, 71706624, 1071339258, 763632021, 1024496933, 1380503552, 1071314217, 1383547992, -1121878843, 1015732224, 1071289325, -1096320419, 1025390322, 35977216, 1071264580, 2141026805, 1025754693, -367661056, 1071239979, 282116272, -1121572962, 1125341184, 1071215523, -1526539792, -1122688237, 1666971648, 1071191208, 786837629, -1122539851, -1467273216, 1071167033, -437844880, -1121953055, 2003683328, 1071142997, 859010954, 1026545007, 1004017664, 1071119098, -938322326, -1121509232, 1753020416, 1071095334, 788338552, 1026157693, 1992718336, 1071071704, 1239179443, 1026394889, -424732672, 1071048206, 2082614663, 1024926053, 1050437632, 1071024840, 660007840, 1025548499, 188395520, 1071001603, -416174592, -1121077725, -547790848, 1070978493, 144991708, -1123415254, 1405669376, 1070955511, -295878417, 1025486317, 121151488, 1070932654, -2124101799, 1026473584, -1642647552, 1070909920, 453695652, -1121050487, -1032730624, 1070887309, 157800053, -1120983090, 601221120, 1070864820, -326049635, 1023992886, 0x77333000, 1070842450, -1241072292, 1024998228, 1992167424, 1070820199, -1326352440, 1024552653, -506241024, 1070798065, -752796488, -1121394054, 2094829568, 1070776048, 1246758132, 1026202874, 288675840, 1070754146, -547638346, 1026331585, 1829681152, 1070732357, -1169769750, 1024100318, 1666869248, 1070710681, 1363656119, 1026336493, -877856768, 1070689116, -140175743, 1026267853, -2111313920, 1070667662, 1671819292, -1121181426, 1734434816, 1070646317, 373091049, 1025972363, 1615681536, 1070625080, 384650897, 1022926043, 1445382144, 1070603950, 344320330, -1122570100, 1823715328, 1070569756, -905126096, 1025231852, -455278592, 1070527917, 1706790417, -1127603947, -1634304, 1070486286, 1614935088, 1019351591, -1328246784, 1070444861, -149573579, -1121255638, -228237312, 1070403639, 1974925028, -1123530114, -957345792, 1070362619, -980014126, -1124995982, 943448064, 1070321799, 1498682038, -1121104956, 1465634816, 1070281176, 1319952810, -1123273331, 1015734272, 1070240749, 1347821929, -1121422781, 118001664, 1070200516, 1751482746, 1026134093, -587792384, 1070160474, 1486946159, 1023930920, -348585984, 1070120623, -1427559215, -1123599020, 1699848192, 1070080961, -1704780157, 1025379803, -2059120640, 1070041485, 1888568069, -1122212336, -1955237888, 1070002194, -442752543, -1121644147, -1098117120, 1069963086, 742141560, 1025101707, 1800683520, 1069924160, -345466852, -1122865117, -459165696, 1069885413, -446071353, 1025913832, -2093764608, 1069846845, 1425913464, 1025868665, -1516687360, 1069808453, 2120889677, -1121136168, -1340764160, 1069770236, 592147081, 1019621288, 210141184, 1069732193, -880692063, 1023647084, 709476352, 1069694321, -1881940132, 1024462115, 2116284416, 1069656619, 1144559924, 1026336654, -2111315968, 1069619086, -835909646, 1025634168, -1247920128, 1069581720, 1879674924, -1121458723, 970711040, 1069541521, 1335954173, -1121635114, -2096488448, 1069467449, -1343863328, -1121075096, 1669611520, 1069393703, 531044147, 1025149248, 29114368, 1069320280, -967136045, 1025918673, -1918017536, 1069247176, 737634533, -1122791296, 1085390848, 1069174390, -1186723896, -1123138890, 1566130176, 1069101918, 985483226, 1025708380, 792780800, 1069029758, -110101001, 1024426204, 183156736, 1068957907, -1449267918, 1022107277, 1301782528, 1068886362, 1012735262, -1121163002, 1562411008, 1068815121, -2097880593, -1124779483, -1479417856, 1068744181, -1512354089, 1026345054, -1538842624, 1068673540, -1365481091, -1121929496, -783917056, 1068603195, 1443733147, -1121635747, -1247920128, 1068533144, 1879674924, -1122507299, -1073299456, 1068427825, 1338588027, -1123151554, -841105408, 1068288883, 1205348359, -1122342670, -788856832, 1068150514, 893105198, 1025571866, 346013696, 1068012714, -799398275, -1122403947, -220938240, 1067875476, -333860958, -1123901701, -735182848, 1067738798, 1975385384, -1121184141, 797769728, 1067602675, -534661509, 1026047642, -1981333504, 1067467101, 1559353171, 1023480256, -334200832, 1067213778, 1067365107, 1025865926, 684261376, 1066944805, 844762164, -1121279814, 630718464, 1066676905, -1836697602, 1024033081, 1486061568, 1066410070, 115537874, -1121723301, -1551302656, 1065886792, -629868992, -1121495689, 1971912704, 1065357333, -1717752856, -1122973845, 1498939392, 1064306693, -885930373, 1025599151, 0, 0, 0, Integer.MIN_VALUE});
    private static ArrayDataPointerConstant log2 = AMD64HotSpotHelper.pointerConstant(8, new int[]{-17156096, 1067855426});
    private static ArrayDataPointerConstant log28 = AMD64HotSpotHelper.pointerConstant(8, new int[]{-1815648464, 1022292823});
    private static ArrayDataPointerConstant coeff = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1840700270, 1069697316, 0, -1076887552});
    private static ArrayDataPointerConstant coeff16 = AMD64HotSpotHelper.pointerConstant(16, new int[]{1030730101, -1077586594, 0x55555555, 1070945621});
    private static ArrayDataPointerConstant coeff32 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1717986918, 1070176665, 0, -1075838976});

    public AMD64MathLogOp() {
        super(TYPE, AMD64.rax, AMD64.rcx, AMD64.rdx, AMD64.r8, AMD64.r11, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label block0 = new Label();
        Label block1 = new Label();
        Label block2 = new Label();
        Label block3 = new Label();
        Label block4 = new Label();
        Label block5 = new Label();
        Label block6 = new Label();
        Label block7 = new Label();
        Label block8 = new Label();
        Label block9 = new Label();
        masm.subq(AMD64.rsp, 24);
        masm.movsd(new AMD64Address(AMD64.rsp, 0), AMD64.xmm0);
        masm.movq(AMD64.rax, 0x3FF0000000000000L);
        masm.movdq(AMD64.xmm2, AMD64.rax);
        masm.movq(AMD64.rdx, 0x77F0000000000000L);
        masm.movdq(AMD64.xmm3, AMD64.rdx);
        masm.movl(AMD64.rcx, 32768);
        masm.movdl(AMD64.xmm4, AMD64.rcx);
        masm.movq(AMD64.r8, -35184372088832L);
        masm.movdq(AMD64.xmm5, AMD64.r8);
        masm.movdqu(AMD64.xmm1, AMD64.xmm0);
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.por(AMD64.xmm0, AMD64.xmm2);
        masm.movl(AMD64.rcx, 16352);
        masm.psrlq(AMD64.xmm0, 27);
        masm.leaq(AMD64.r11, AMD64HotSpotHelper.recordExternalAddress(crb, lTbl));
        masm.psrld(AMD64.xmm0, 2);
        masm.rcpps(AMD64.xmm0, AMD64.xmm0);
        masm.psllq(AMD64.xmm1, 12);
        masm.pshufd(AMD64.xmm6, AMD64.xmm5, 228);
        masm.psrlq(AMD64.xmm1, 12);
        masm.subl(AMD64.rax, 16);
        masm.cmplAndJcc(AMD64.rax, 32736, AMD64Assembler.ConditionFlag.AboveEqual, block0, false);
        masm.bind(block1);
        masm.paddd(AMD64.xmm0, AMD64.xmm4);
        masm.por(AMD64.xmm1, AMD64.xmm3);
        masm.movdl(AMD64.rdx, AMD64.xmm0);
        masm.psllq(AMD64.xmm0, 29);
        masm.pand(AMD64.xmm5, AMD64.xmm1);
        masm.pand(AMD64.xmm0, AMD64.xmm6);
        masm.subsd(AMD64.xmm1, AMD64.xmm5);
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.andl(AMD64.rax, 32752);
        masm.subl(AMD64.rax, AMD64.rcx);
        masm.cvtsi2sdl(AMD64.xmm7, AMD64.rax);
        masm.mulsd(AMD64.xmm1, AMD64.xmm0);
        masm.movq(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, log2));
        masm.movdqu(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, coeff));
        masm.subsd(AMD64.xmm5, AMD64.xmm2);
        masm.andl(AMD64.rdx, 0xFF0000);
        masm.shrl(AMD64.rdx, 12);
        masm.movdqu(AMD64.xmm0, new AMD64Address(AMD64.r11, AMD64.rdx, Stride.S1));
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, coeff16));
        masm.addsd(AMD64.xmm1, AMD64.xmm5);
        masm.movdqu(AMD64.xmm2, AMD64HotSpotHelper.recordExternalAddress(crb, coeff32));
        masm.mulsd(AMD64.xmm6, AMD64.xmm7);
        if (masm.supports(AMD64.CPUFeature.SSE3)) {
            masm.movddup(AMD64.xmm5, AMD64.xmm1);
        } else {
            masm.movdqu(AMD64.xmm5, AMD64.xmm1);
            masm.movlhps(AMD64.xmm5, AMD64.xmm5);
        }
        masm.mulsd(AMD64.xmm7, AMD64HotSpotHelper.recordExternalAddress(crb, log28));
        masm.mulsd(AMD64.xmm3, AMD64.xmm1);
        masm.addsd(AMD64.xmm0, AMD64.xmm6);
        masm.mulpd(AMD64.xmm4, AMD64.xmm5);
        masm.mulpd(AMD64.xmm5, AMD64.xmm5);
        if (masm.supports(AMD64.CPUFeature.SSE3)) {
            masm.movddup(AMD64.xmm6, AMD64.xmm0);
        } else {
            masm.movdqu(AMD64.xmm6, AMD64.xmm0);
            masm.movlhps(AMD64.xmm6, AMD64.xmm6);
        }
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.addpd(AMD64.xmm4, AMD64.xmm2);
        masm.mulpd(AMD64.xmm3, AMD64.xmm5);
        masm.subsd(AMD64.xmm6, AMD64.xmm0);
        masm.mulsd(AMD64.xmm4, AMD64.xmm1);
        masm.pshufd(AMD64.xmm2, AMD64.xmm0, 238);
        masm.addsd(AMD64.xmm1, AMD64.xmm6);
        masm.mulsd(AMD64.xmm5, AMD64.xmm5);
        masm.addsd(AMD64.xmm7, AMD64.xmm2);
        masm.addpd(AMD64.xmm4, AMD64.xmm3);
        masm.addsd(AMD64.xmm1, AMD64.xmm7);
        masm.mulpd(AMD64.xmm4, AMD64.xmm5);
        masm.addsd(AMD64.xmm1, AMD64.xmm4);
        masm.pshufd(AMD64.xmm5, AMD64.xmm4, 238);
        masm.addsd(AMD64.xmm1, AMD64.xmm5);
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.jmp(block9);
        masm.bind(block0);
        masm.movq(AMD64.xmm0, new AMD64Address(AMD64.rsp, 0));
        masm.movq(AMD64.xmm1, new AMD64Address(AMD64.rsp, 0));
        masm.addl(AMD64.rax, 16);
        masm.cmplAndJcc(AMD64.rax, 32768, AMD64Assembler.ConditionFlag.AboveEqual, block2, false);
        masm.cmplAndJcc(AMD64.rax, 16, AMD64Assembler.ConditionFlag.Below, block3, false);
        masm.bind(block4);
        masm.addsd(AMD64.xmm0, AMD64.xmm0);
        masm.jmp(block9);
        masm.bind(block5);
        masm.jcc(AMD64Assembler.ConditionFlag.Above, block4);
        masm.cmplAndJcc(AMD64.rdx, 0, AMD64Assembler.ConditionFlag.Above, block4, false);
        masm.jmp(block6);
        masm.bind(block3);
        masm.xorpd(AMD64.xmm1, AMD64.xmm1);
        masm.addsd(AMD64.xmm1, AMD64.xmm0);
        masm.movdl(AMD64.rdx, AMD64.xmm1);
        masm.psrlq(AMD64.xmm1, 32);
        masm.movdl(AMD64.rcx, AMD64.xmm1);
        masm.orl(AMD64.rdx, AMD64.rcx);
        masm.cmplAndJcc(AMD64.rdx, 0, AMD64Assembler.ConditionFlag.Equal, block7, false);
        masm.xorpd(AMD64.xmm1, AMD64.xmm1);
        masm.movl(AMD64.rax, 18416);
        masm.pinsrw(AMD64.xmm1, AMD64.rax, 3);
        masm.mulsd(AMD64.xmm0, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, AMD64.xmm0);
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.por(AMD64.xmm0, AMD64.xmm2);
        masm.psrlq(AMD64.xmm0, 27);
        masm.movl(AMD64.rcx, 18416);
        masm.psrld(AMD64.xmm0, 2);
        masm.rcpps(AMD64.xmm0, AMD64.xmm0);
        masm.psllq(AMD64.xmm1, 12);
        masm.pshufd(AMD64.xmm6, AMD64.xmm5, 228);
        masm.psrlq(AMD64.xmm1, 12);
        masm.jmp(block1);
        masm.bind(block2);
        masm.movdl(AMD64.rdx, AMD64.xmm1);
        masm.psrlq(AMD64.xmm1, 32);
        masm.movdl(AMD64.rcx, AMD64.xmm1);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.cmplAndJcc(AMD64.rcx, -2097152, AMD64Assembler.ConditionFlag.AboveEqual, block5, false);
        masm.orl(AMD64.rdx, AMD64.rcx);
        masm.cmplAndJcc(AMD64.rdx, 0, AMD64Assembler.ConditionFlag.Equal, block7, false);
        masm.bind(block6);
        masm.xorpd(AMD64.xmm1, AMD64.xmm1);
        masm.xorpd(AMD64.xmm0, AMD64.xmm0);
        masm.movl(AMD64.rax, 32752);
        masm.pinsrw(AMD64.xmm1, AMD64.rax, 3);
        masm.mulsd(AMD64.xmm0, AMD64.xmm1);
        masm.movl(new AMD64Address(AMD64.rsp, 16), 3);
        masm.jmp(block8);
        masm.bind(block7);
        masm.xorpd(AMD64.xmm1, AMD64.xmm1);
        masm.xorpd(AMD64.xmm0, AMD64.xmm0);
        masm.movl(AMD64.rax, 49136);
        masm.pinsrw(AMD64.xmm0, AMD64.rax, 3);
        masm.divsd(AMD64.xmm0, AMD64.xmm1);
        masm.movl(new AMD64Address(AMD64.rsp, 16), 2);
        masm.bind(block8);
        masm.movq(new AMD64Address(AMD64.rsp, 8), AMD64.xmm0);
        masm.movq(AMD64.xmm0, new AMD64Address(AMD64.rsp, 8));
        masm.bind(block9);
        masm.addq(AMD64.rsp, 24);
    }
}

