/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPort(path="src/hotspot/cpu/x86/macroAssembler_x86.hpp", lineStart=205, lineEnd=208, commit="b1d89f30663aed28783e839c5690f46a2b382002", sha1="98a131f29df93d80b238dc0a8c812fed59bd072d")
public final class AMD64HalfFloatToFloatOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HalfFloatToFloatOp> TYPE = LIRInstructionClass.create(AMD64HalfFloatToFloatOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;

    public AMD64HalfFloatToFloatOp(Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        masm.movdl(dst, src);
        masm.vcvtph2ps(dst, dst);
    }
}

