/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.lir.framemap.FrameMap;

public class AMD64FrameMap
extends FrameMap {
    protected final boolean preserveFramePointer;

    public AMD64FrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory, boolean preserveFramePointer) {
        super(codeCache, registerConfig, referenceMapFactory);
        this.preserveFramePointer = preserveFramePointer;
        this.spillSize = this.initialSpillSize = this.returnAddressSize() + (preserveFramePointer ? this.getTarget().arch.getWordSize() : 0);
    }

    @Override
    public int totalFrameSize() {
        int result = this.frameSize() + this.initialSpillSize;
        assert (result % this.getTarget().stackAlignment == 0) : "Total frame size not aligned: " + result;
        return result;
    }

    @Override
    public int currentFrameSize() {
        return this.alignFrameSize(this.outgoingSize + this.spillSize - this.initialSpillSize);
    }

    @Override
    protected int alignFrameSize(int size) {
        return NumUtil.roundUp(size + this.initialSpillSize, this.getTarget().stackAlignment) - this.initialSpillSize;
    }

    @Override
    public int offsetForStackSlot(StackSlot slot) {
        assert (!slot.getRawAddFrameSize() && slot.getRawOffset() < this.outgoingSize || slot.getRawAddFrameSize() && slot.getRawOffset() < 0 && -slot.getRawOffset() <= this.spillSize || slot.getRawAddFrameSize() && slot.getRawOffset() >= 0) : String.format("RawAddFrameSize: %b RawOffset: 0x%x spillSize: 0x%x outgoingSize: 0x%x", slot.getRawAddFrameSize(), slot.getRawOffset(), this.spillSize, this.outgoingSize);
        return super.offsetForStackSlot(slot);
    }

    public boolean preserveFramePointer() {
        return this.preserveFramePointer;
    }
}

