/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@StubPort(path="src/hotspot/cpu/x86/c2_MacroAssembler_x86.cpp", lineStart=5664, lineEnd=5746, commit="afda8fbf0bcea18cbe741e9c693789ebe0c6c4c5", sha1="00fb0bbf3d9eee0ceaf2ef39aaeae214b9c91c59")
public final class AMD64BitSwapOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64BitSwapOp> TYPE = LIRInstructionClass.create(AMD64BitSwapOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value rtmpValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value rtmp2Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value xtmp1Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value xtmp2Value;

    public AMD64BitSwapOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.rtmpValue = tool.newVariable(dstValue.getValueKind());
        if (AMD64BitSwapOp.supportsGFNI(tool.target().arch)) {
            this.rtmp2Value = Value.ILLEGAL;
            LIRKind lirKind = LIRKind.value((PlatformKind)AMD64Kind.DOUBLE);
            this.xtmp1Value = tool.newVariable(lirKind);
            this.xtmp2Value = tool.newVariable(lirKind);
        } else {
            this.rtmp2Value = dstValue.getPlatformKind() == AMD64Kind.QWORD ? tool.newVariable(dstValue.getValueKind()) : Value.ILLEGAL;
            this.xtmp1Value = Value.ILLEGAL;
            this.xtmp2Value = Value.ILLEGAL;
        }
    }

    private static boolean supportsGFNI(Architecture arch) {
        try {
            return arch.getFeatures().contains(AMD64.CPUFeature.valueOf((String)"GFNI"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register rtmp = ValueUtil.asRegister((Value)this.rtmpValue);
        switch ((AMD64Kind)this.dstValue.getPlatformKind()) {
            case DWORD: {
                if (masm.supportsCPUFeature("GFNI")) {
                    Register xtmp1 = ValueUtil.asRegister((Value)this.xtmp1Value);
                    Register xtmp2 = ValueUtil.asRegister((Value)this.xtmp2Value);
                    masm.movq(rtmp, -9205322385119247871L);
                    masm.movdq(xtmp1, src);
                    masm.movdq(xtmp2, rtmp);
                    masm.gf2p8affineqb(xtmp1, xtmp2, 0);
                    masm.movdq(dst, xtmp1);
                } else {
                    masm.movl(rtmp, src);
                    masm.andl(rtmp, 0x55555555);
                    masm.shll(rtmp, 1);
                    masm.movl(dst, src);
                    masm.andl(dst, -1431655766);
                    masm.shrl(dst, 1);
                    masm.orl(dst, rtmp);
                    masm.movl(rtmp, dst);
                    masm.andl(rtmp, 0x33333333);
                    masm.shll(rtmp, 2);
                    masm.andl(dst, -858993460);
                    masm.shrl(dst, 2);
                    masm.orl(dst, rtmp);
                    masm.movl(rtmp, dst);
                    masm.andl(rtmp, 0xF0F0F0F);
                    masm.shll(rtmp, 4);
                    masm.andl(dst, -252645136);
                    masm.shrl(dst, 4);
                    masm.orl(dst, rtmp);
                }
                masm.bswapl(dst);
                break;
            }
            case QWORD: {
                if (masm.supportsCPUFeature("GFNI")) {
                    Register xtmp1 = ValueUtil.asRegister((Value)this.xtmp1Value);
                    Register xtmp2 = ValueUtil.asRegister((Value)this.xtmp2Value);
                    masm.movq(rtmp, -9205322385119247871L);
                    masm.movdq(xtmp1, src);
                    masm.movdq(xtmp2, rtmp);
                    masm.gf2p8affineqb(xtmp1, xtmp2, 0);
                    masm.movdq(dst, xtmp1);
                } else {
                    Register rtmp1 = rtmp;
                    Register rtmp2 = ValueUtil.asRegister((Value)this.rtmp2Value);
                    masm.movq(rtmp1, src);
                    masm.movq(rtmp2, 0x5555555555555555L);
                    masm.andq(rtmp1, rtmp2);
                    masm.shlq(rtmp1, 1);
                    masm.movq(dst, src);
                    masm.notq(rtmp2);
                    masm.andq(dst, rtmp2);
                    masm.shrq(dst, 1);
                    masm.orq(dst, rtmp1);
                    masm.movq(rtmp1, dst);
                    masm.movq(rtmp2, 0x3333333333333333L);
                    masm.andq(rtmp1, rtmp2);
                    masm.shlq(rtmp1, 2);
                    masm.notq(rtmp2);
                    masm.andq(dst, rtmp2);
                    masm.shrq(dst, 2);
                    masm.orq(dst, rtmp1);
                    masm.movq(rtmp1, dst);
                    masm.movq(rtmp2, 0xF0F0F0F0F0F0F0FL);
                    masm.andq(rtmp1, rtmp2);
                    masm.shlq(rtmp1, 4);
                    masm.notq(rtmp2);
                    masm.andq(dst, rtmp2);
                    masm.shrq(dst, 4);
                    masm.orq(dst, rtmp1);
                }
                masm.bswapq(dst);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }
}

